#!/bin/sh
#
# sendkit.sh -	send a signup kit to a user
#
#	Usage: sendkit.sh <type>
#
#		where <type> is WIN31 or WIN95
#

MIMETYPE='Application/OCTET-stream' ;
case $1 in
  TEST) KITTYPE="Test"; KIT=/var/lib/ISPutil/util/sendkit.sh ;;
  BASIC) KITTYPE="Basic"; KIT=/ftp/pub/MNET_Signup/MNKbasic.exe ;;
  WIN31) KITTYPE="Windows 3.x"; KIT=/ftp/pub/MNET_Signup/Mount31.exe ;;
  WIN95) KITTYPE="Windows 95"; KIT=/ftp/pub/MNET_Signup/Mount95.exe ;;
  *) echo "Usage: sendkit.sh <KitType>" ; exit ;;
esac

do_exit() {
  echo -n "[ Press Enter ]"
  read yn
  echo
  exit $1
}

reset
echo "Send a user a $KITTYPE signup kit."
echo
echo this routine emails a user a $KITTYPE signup kit.
echo
if [ ! -f $KIT ]; then
  echo "$KIT not found."
  echo
  do_exit 1
fi
echo -n "Username to send to: "
read uname
echo
if [ -z $uname ]; then
  do_exit 1
fi
echo -n "At mountnet.com? [Y/n]: "
read yn
echo
case $yn in
 N*|n*) echo "Enter host $uname is at: ";
	read uhost; echo;
	if [ -z $uhost ]; then
	  do_exit 1
	fi
	eaddr="$uname@$uhost"
	;;
 *) eaddr="$uname@mountnet.com" ;;
esac
echo "Send $KIT kit to $eaddr"
echo
echo -n "Are you sure? [y/N]: "
read yn
echo
case $yn in
 Y*|y*)  ;;
 *) do_exit 0 ;;
esac
bname=`basename $KIT`
MIMETYPE="$MIMETYPE;name=\"$bname\""
metasend -b -s "Startup Kit" \
	-e base64 -t $eaddr -f $KIT -m "$MIMETYPE" -S 8000000 -c ""
if [ ! $? ]; then
  echo Sent.
  echo
fi
do_exit 0
