#!/bin/sh
#
# retire.sh - retire a user
#

# where is ISP utilities library:
ISPUTIL="/var/lib/ISPutil"
# where does mail go?
MAILHOST="mail.cin-tech.ns.ca"
# where is "doas"?
DOAS="/var/lib/ISPutil/bin/doas"

function exitfunc() {
  echo
  echo -n "[ Press Enter ]"
  read
  exit 1
}

reset
echo "Retire a user"
echo "-------------"
echo
if [ "$USER" = "" ]; then
  USER=$LOGNAME
fi
echo "Staffperson is: $USER"
echo
echo "What is the username of the whom you wish retired?"
echo
echo -n "Username: "
read user
echo
if [ "$user" = "" ]; then
  echo "No username given."
  exitfunc
fi
pwln=`grep ^$user: /etc/passwd`
if [ "$pwln" = "" ]; then
  echo "Username $user not on file."
  exitfunc
fi
/usr/bin/finger $user
name=`echo $pwln | cut -d ":" -f 5`
echo "User's realname: $name"
group=`id -gn $user`
echo "User's group is: $group"
uid=`id -u $user`
echo
if [ "$group" != "guest" -a "$group" != "slipin" -a "$group" != "users" ]
then
  echo "Sorry, user $user is not in the groups guest slipin or users."
  exitfunc
fi
echo -n "Are you sure about this? [y/N]: "
read i
case $i in
    y) ;;
  yes) ;;
    Y) ;;
  Yes) ;;
  YES) ;;
    *) exit ;;
esac
echo
echo "Changing $user to retired for $USER ..."
echo
# change their shell
$DOAS 0 /usr/bin/chsh -s /shells/retired $user
# write home about it
BLURB="retire: $USER changed $user to retired user"
echo `date`" "$BLURB >> /var/adm/isputil.log
mail -s "$BLURB" accounts@$MAILHOST -c $USER <<-EOF
	$BLURB
	EOF
# unsubscribe them from the users mailing-list
mail majordomo@$MAILHOST <<EOF
unsubscribe users $user
EOF
echo -n "[ Press Enter ]"
read
