#!/bin/sh
#
# mkslipinhome.sh -	make homedir for slipin/pppin user
#
#	Syntax:	mkslipinhome <username>
#
#		This script requires root permissions.
#
#		This script is called by makeslip and makeppp
#		to do user's home directory home page etc.
#

# where is mailhost:
MAILHOST="mail.cin-tech.ns.ca"
# where is webserver:
WEBSERVER="www.cin-tech.ns.ca"

# where is utilities library:
ISPUTIL="/var/lib/ISPutil"
ISPDBS="/var/lib/ISPutil/qdDBs"
USERDB=$ISPDBS/Clients
# where is WWWutil package
WWWUTIL="/var/lib/WWWutil"
PAGEMAKE=$WWWUTIL/pagemake

# where is qddb query program
QDDBBIN=/usr/local/qddb/bin
QUERY=$QDDBBIN/query

user=$1

# correct the permissions on their home directory
/bin/chmod go+rx /home/$user
# set their quota using "guest" as prototype
#/usr/sbin/edquota -p guest $user
if [ ! -d /home/$user/public_html ]; then
  mkdir /home/$user/public_html
fi
# correct the permissions on their public_html directory
/bin/chmod go+rx /home/$user/public_html
/bin/chgrp www /home/$user/public_html

#
# generate their homepage
#
STYLE=`$QUERY $USERDB -sep '' Company.Contact.Username $user \
	-print Company.Contact.WebProject.Style`
TEMPLATE=$PAGEMAKE/user$STYLE.style
$PAGEMAKE/qsub $USERDB Company.Contact.Username $user $TEMPLATE \
	> /home/$user/public_html/index.spider


chown -R $user.slipin /home/$user
chgrp -R www /home/$user/public_html
chmod -R g+w /home/$user/public_html

