#!/bin/sh
#
# makeslip.sh - turn a guest user into a slip user
#

# where is utilities library:
ISPUTIL="/var/lib/ISPutil"
# where is mailhost:
MAILHOST="mail.cin-tech.ns.ca"
# where is webserver:
WEBSERVER="www.cin-tech.ns.ca"

reset
echo "Make a user into a slip user"
echo "----------------------------"
echo
if [ "$USER" = "" ]; then
  USER=$LOGNAME
fi
echo "Salesperson is: $USER"
echo
echo "What is the username of the user whom you wish converted?"
echo
echo -n "Username: "
read user
echo
if [ "$user" = "" ]; then
  echo "No username given."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
pwln=`grep "^$user:" /etc/passwd`
if [ "$pwln" = "" ]; then
  echo "Username $user not found in user-database."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
name=`echo $pwln | cut -d ":" -f 5`
echo "User's realname: $name"
group=`echo $pwln | cut -d ":" -f 4`
echo "User's group is: $group"
echo
if [ "$group" != "26" ]; then
  echo "Sorry, user $user is not a member of the group slipin."
  echo
  echo -n "[ Press Enter ]"
  read
  exit
fi
echo -n "Are you sure about this? [N/y]: "
read i
case $i in
    y) ;;
  yes) ;;
    Y) ;;
  Yes) ;;
  YES) ;;
    *) exit ;;
esac
echo
echo "Changing $user to slipin for $USER ..."
echo
# check if /etc/passwd is locked:
if [ -f /etc/passwd.lock ]; then
  sleep 2;
  if [ -f /etc/passwd.lock ]; then
    echo "The user database seems to be locked."
    echo "I am automatically sending mail to the system admins"
    echo "complaining about this, in meantime, my apologies but"
    echo "I cannot convert $user to group $group at this time."
    mail -s "/etc/passwd found locked!" root <<-EOF
	The makeslip routine found /etc/passwd.lock to exist
	thus is unable to act. Please look into this A.S.A.P. 
	EOF
    echo
    echo -n "[ Press Enter ]"
    read
    exit
  fi
fi

#
# change their login group and shell
# be super-careful about /etc/passwd always existing:
#
echo $$ > /etc/passwd.lock
cp /etc/passwd /etc/passwd.$$
ln -f /etc/passwd.$$ /etc/passwd
awk -f $ISPUTIL/util/makeslip.awk -v user=$user /etc/passwd >/tmp/passwd.$$
mv -f /tmp/passwd.$$ /etc/passwd
rm /etc/passwd.$$
rm /etc/passwd.lock

#
# update yellowpages database:
#
#/usr/lib/yp/pwupdate

#
# write a log entry
#
echo `date`" makeslip: $USER changed $user to slipin user" \
	>> /var/adm/isputil.log
mail -s "makeslip: $USER changed $user to slipin user" \
	accounts@$MAILHOST -c $USER <<-EOF 
	$USER changed $user to slipin user
	EOF

echo -n "[ Press Enter ]"
read
