#!/bin/sh
#
# kitsmenu.sh - menu for sending kits to users
#


# these will get substituted at install if up against left margin

ISPUTIL="/var/lib/ISPutil"
HOSTNAME=`hostname`
DNSDOMAINNAME=`dnsdomainname`
EDITOR="/usr/bin/pico -t"
VISUAL="$EDITOR"
QUOTA="/usr/bin/quota"
REPQUOTA="/usr/sbin/repquota"
SUPER="/usr/bin/super"

# these will not get substituted at install because not against margin

 TITLE="$HOSTNAME.$DNSDOMAINNAME Kits"


DONE=
while [ -z $DONE ]; do
        reset
        dialog --title " $TITLE" \
	        --menu "User Signup Kits" 13 50 3 \
		"WIN31"  "Windows 3.x kit" \
		"WIN95"  "Windows 95 kit" \
	        "X=EXIT" "Exit this menu" 2> /tmp/kitmenu.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/kitmenu.$$
                exit
        fi
	mchoice=`cat /tmp/kitmenu.$$`
        /bin/rm -f /tmp/kitmenu.$$

        if [ "$mchoice" = "WIN31" ]; then
        $ISPUTIL/util/sendkit.sh WIN31
        fi
        if [ "$mchoice" = "WIN95" ]; then
        $ISPUTIL/util/sendkit.sh WIN95
        fi
        if [ "$mchoice" = "X=EXIT" ]; then
        DONE=DONE
        fi
done
