#!/bin/sh
#
# config.sh -	Configure WWWutil package makefiles from paths.dat file
#
#		Assumes pwd is the WWWutil directory.
#
#		Rewrites the Makefiles and shell scripts with path info.
#

if [ ! -f ./paths.dat ]; then
  echo "$0: paths.dat not found."
  exit 1
fi

. ./paths.dat

for d in root menus util shells.mainhost shells.modemhost \
	root/cmds.modemhost root/cmds.mainhost ; do
    if [ -d $d ]; then
	pushd $d
	for f in * ; do
	    if [ -f $f ]; then
		sed $f -e "s@^WWWUTIL=.*@WWWUTIL=\"$WWWUTIL\"@" \
			-e "s@^ISPUTIL=.*@ISPUTIL=\"$ISPUTIL\"@" \
			-e "s@^BBSUTIL=.*@BBSUTIL=\"$BBSUTIL\"@" \
			-e "s@^ISPDBS=.*@ISPDBS=\"$ISPDBS\"@" \
			-e "s@^WWWDBS=.*@WWWDBS=\"$WWWDBS\"@" \
			-e "s@^MAINHOST=.*@MAINHOST=\"$MAINHOST\"@" \
			-e "s@^MAILHOST=.*@MAILHOST=\"$MAILHOST\"@" \
			-e "s@^WEBSERVER=.*@WEBSERVER=\"$WEBSERVER\"@" \
			-e "s@^MODEMHOST=.*@MODEMHOST=\"$MODEMHOST\"@" \
			-e "s@^QBIN=.*@QBIN=\"$QBIN\"@" \
			-e "s@^EDITOR=.*@EDITOR=\"$EDITOR\"@" \
			-e "s@^SYSOPEDITOR=.*@SYSOPEDITOR=\"$SYSOPEDITOR\"@" \
			-e "s@^DOAS=.*@DOAS=\"$DOAS\"@" \
			-e "s@^MAKE=.*@MAKE=\"$MAKE\"@" \
			-e "s@^MAKEPKG=.*@MAKEPKG=\"$MAKEPKG\"@" \
			-e "s@^SORT=.*@SORT=\"$SORT\"@" \
			-e "s@^DATE=.*@DATE=\"$DATE\"@" \
			-e "s@^AWK=.*@AWK=\"$AWK\"@" \
			-e "s@^QUOTA=.*@QUOTA=\"$QUOTA\"@" \
			-e "s@^REPQUOTA=.*@REPQUOTA=\"$REPQUOTA\"@" \
			-e "s@^SUPER=.*@SUPER=\"$SUPER\"@" \
			-e "s@^PRIORITY=.*@PRIORITY=\"$PRIORITY\"@" \
			> $f.new
		cp $f.new $f
		rm $f.new
	    fi
	done
	popd
    fi
done

