#!/bin/sh
#
# arrear.sh - set a user's shell to the "arrears" shell
#

# where is ISP utilities library:
ISPUTIL="/var/lib/ISPutil"
ISPDBS="/var/lib/ISPutil/qdDBs"
# where is user database?
USERDB=$ISPDBS/Clients
# where is database query program?
QUERY=/usr/local/qddb/bin/query
# where does mail go?
MAILHOST="mail.cin-tech.ns.ca"
# where is "doas"?
DOAS="/var/lib/ISPutil/bin/doas"

function exitfunc() {
  echo
  echo -n "[ Press Enter ]"
  read
  exit 1
}

reset
echo "Arrear a user"
echo "-------------"
echo
if [ "$USER" = "" ]; then
  USER=$LOGNAME
fi
echo "Staffperson is: $USER"
echo
echo "What is the username whose account is in arrears ?"
echo
echo -n "Username: "
read user
echo
if [ "$user" = "" ]; then
  echo "No username given."
  exitfunc
fi
pwln=`grep ^$user: /etc/passwd`
if [ "$pwln" = "" ]; then
  echo "Username $user not on file."
  exitfunc
fi
/usr/bin/finger $user
name=`echo $pwln | cut -d ":" -f 5`
echo "User's realname: $name"
group=`id -gn $user`
echo "User's group is: $group"
uid=`id -u $user`
echo
if [ "$group" != "guest" -a "$group" != "slipin" -a "$group" != "users" ]
then
  echo "Sorry, user $user is not in the group guest slipin or users."
  exitfunc
fi
credit="`$QUERY $USERDB -sep ' ' Company.Contact.Username $user \
		-print CreditLimit`"
if [ "$credit" = "" ]; then
  credit=0.00
fi
echo "$user's Credit Limit now is $credit"
echo
balance="`$QUERY $USERDB -sep ' ' Company.Contact.Username $user \
		-print CurrentBalance`"
if [ "$balance" = "" ]; then
  balance=0.00
fi
echo "$user's Current Balance is  $balance"
pending="`$QUERY $USERDB -sep ' ' Company.Contact.Username $user \
		-print Pending`"
if [ "$pending" = "" ]; then
  pending=0.00
fi
echo "$user's Pending Amount is $pending"
echo
OK=`echo "$credit <= ($balance + $pending)" | /usr/bin/bc`
if [ "$OK" != "1" ]; then
  echo "There must be some mistake, $user has good credit!"
  exitfunc
fi
echo -n "Are you sure about this? [y/N]: "
read i
case $i in
    y) ;;
  yes) ;;
    Y) ;;
  Yes) ;;
  YES) ;;
    *) exit ;;
esac
echo
echo "Changing $user to retired for $USER ..."
echo
# change their shell
$DOAS 0 /usr/bin/chsh -s /shells/arrears $user
# write home about it
BLURB="arrear: $USER changed $user to arrears user"
echo `date`" "$BLURB >> /var/adm/isputil.log
mail -s "$BLURB" accounts@$MAILHOST -c $USER <<-EOF
	$BLURB
EOF
# unsubscribe them from the users mailing-list
#mail majordomo@$MAILHOST <<EOF
#unsubscribe users $user
#EOF
echo -n "[ Press Enter ]"
read
