#!/bin/sh
#
# Copyright (c)1995 by Emmett Sauer & Linux Business Systems
# This is NOT Shareware.. This is Freeware.. This can be included with
# any package as long as these copyright notices stay intact with the software.
#
# Linux Business Systems - retains all rights to this script file and are by no
# means liable for any damages that may be incurred when using.  It is the 
# users responsibilty to know the consequences of the actions of commands given
# or programs called when using this software.
# 
# Linux Business Systems is not responsible for any other software that may used
# in conjunction with the Admin Menu.  We make no claims as to the validity of
# any other software used other than it works on our machines.  
#
# It is requested that if you make any changes that you forward the changes to 
# us to be considered for another release.
#
# emmetts@squeaky.free.org
#
reset
log_name=`whoami`
log_group=`groups`
hostname=`hostname`
dnsdomainname=`dnsdomainname`
TITLE="$hostname.$dnsdomainname Admin Menu"
EGROUP=/etc/group
EPWORD=/etc/passwd
UMAIL=/var/spool/mail
PWBACK=/var/adm/passwd.bu.$UID
GRPBACK=/var/adm/group.bu.$UID

# This is for your preferred editor
AEDIT=/usr/bin/pico
EDITOR="/usr/bin/pico -t"
#

main()
{
while [ 0 ]; do
	reset
	dialog --title " $TITLE " \
	--menu "MAIN" 15 50 8 \
	"1" "Security " \
	"2" "System Accounting " \
	"3" "Network " \
	"4" "News & Mail " \
	"5" "Printer " \
	"6" "System Maintainance" \
	"7" "Utilities" \
	"Q" "QUIT" 2> /tmp/mch.tmp.$$
	if [ $? = 1 -o $? = 255 ]; then
		/bin/rm -f /tmp/tmpmsg.$$ /tmp/mch.tmp.$$
		exit
	fi
	choice=`cat /tmp/mch.tmp.$$`
	/bin/rm -f /tmp/mch.tmp.$$
	if [ "$choice" = "1" ]; then
	secmain
	fi
	if [ "$choice" = "2" ]; then
        acctmain
        fi
	if [ "$choice" = "3" ]; then
	nmenu
	fi
	if [ "$choice" = "4" ]; then
	nmmenu
	fi
	if [ "$choice" = "5" ]; then
	prnt-mgmt
	fi
	if [ "$choice" = "6" ]; then
        smain
        fi
	if [ "$choice" = "7" ]; then
        utils
        fi
	if [ "$choice" = "Q" ]; then
        leave
        fi
done
}

secmain()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "User Menu" 15 50 6 \
        "1" "User Menu" \
        "2" "Group Menu" \
        "3" "Users on `hostname`" \
 	"4" "Last 15 System Users" \
	"5" "Login-Logout LOG" \
        "Q" "QUIT to Main Menu" 2> /tmp/uch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/uch.tmp.$$
                exit
        fi
        uchoice=`cat /tmp/uch.tmp.$$`
        /bin/rm -f /tmp/uch.tmp.$$
        if [ "$uchoice" = "1" ]; then
        umain
	fi
	if [ "$uchoice" = "2" ]; then
	gmain
	fi
	if [ "$uchoice" = "3" ]; then
	users > /tmp/users.tmp.$$
        dialog --title "System Users" \
        --textbox /tmp/users.tmp.$$ 18 76
        /bin/rm -f /tmp/users.tmp.$$
        fi
	if [ "$uchoice" = "4" ]; then
        last -15 > /tmp/users15.tmp.$$
        dialog --title "Last 15 System Users" \
        --textbox /tmp/users15.tmp.$$ 18 76
        /bin/rm -f /tmp/users15.tmp.$$
        fi
	if [ "$uchoice" = "5" ]; then
        /sbin/login.info > /tmp/lusers.tmp.$$
        dialog --title "System Users" \
        --textbox /tmp/lusers.tmp.$$ 18 76
        /bin/rm -f /tmp/lusers.tmp.$$
        fi
	if [ "$uchoice" = "Q" ]; then
	main
	fi
done
}
acctmain()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "System Accounting " 12 50 6 \
        "1" "User Quotas" \
        "2" "Group Quotas" \
        "3" "Edit A User Quotas" \
	"4" "Edit Groups Users Quotas"\
        "5" "User time on" \
        "Q" "QUIT to Main Menu" 2> /tmp/uch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/uch.tmp.$$
                exit
        fi
        uchoice=`cat /tmp/uch.tmp.$$`
        /bin/rm -f /tmp/uch.tmp.$$

        if [ "$uchoice" = "1" ]; then
        /usr/sbin/repquota -au >/tmp/repquota.tmp.$$
        dialog --title "User quotas on System" \
        --textbox /tmp/repquota.tmp.$$ 18 76
        /bin/rm -f /tmp/repquota.tmp.$$
        fi

        if [ "$uchoice" = "2" ]; then
        /usr/sbin/repquota -avg >/tmp/gpquota.tmp.$$
        dialog --title "Group quotas on System" \
        --textbox /tmp/gpquota.tmp.$$ 18 76
        /bin/rm -f /tmp/gpquota.tmp.$$
        fi

        if [ "$uchoice" = "3" ]; then
	dialog --title "Edit quotas" \
        --inputbox "User to Edit:" 15 46 2> /tmp/quser.tmp.$$
	/usr/sbin/edquota -u `cat /tmp/quser.tmp.$$`
	/bin/rm -f /tmp/quser.tmp.$$ 
	fi

        if [ "$uchoice" = "4" ]; then
        /usr/sbin/edquota -g users
        fi	

	if [ "$uchoice" = "5" ]; then
	/usr/local/bin/sac -dpa >/tmp/utime.tmp
        dialog --title "Users time on System" \
        --textbox /tmp/utime.tmp 18 76
        /bin/rm -f /tmp/utime.tmp
	fi

        if [ "$uchoice" = "Q" ]; then
        main
        fi
done
}

nmmenu()
{
while [ 0 ]; do
        dialog --title " News and Mail" \
        --msgbox "Not Implemented Yet!" 12 50 
	main
done
}        

umain()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "User Menu" 12 50 4 \
        "1" "Arrear user" \
        "2" "List Users" \
        "3" "New User" \
	"4" "PPP user" \
	"5" "Retire user" \
	"6" "SLIP user" \
        "Q" "QUIT to Security Menu" 2> /tmp/uch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/uch.tmp.$$
                exit
        fi
	uchoice=`cat /tmp/uch.tmp.$$`
        /bin/rm -f /tmp/uch.tmp.$$
        if [ "$uchoice" = "1" ]; then
        /var/lib/ISPutil/arrear.sh
        fi
        if [ "$uchoice" = "2" ]; then
	cat /etc/passwd > /tmp/tpwd.$$
        dialog --title "`hostname`'s Users" \
	--textbox /tmp/tpwd.$$ 18 70 
	/bin/rm -f /tmp/tpwd.$$
        fi
        if [ "$uchoice" = "3" ]; then
        /var/lib/ISPutil/newuser.sh
        fi
        if [ "$uchoice" = "4" ]; then
        /var/lib/ISPutil/makeppp.sh
        fi
        if [ "$uchoice" = "5" ]; then
        /var/lib/ISPutil/makeslip.sh
        fi
        if [ "$uchoice" = "6" ]; then
        /var/lib/ISPutil/retire.sh
        fi
        if [ "$uchoice" = "Q" ]; then
        secmain
        fi
done
}

gmain()
{
while [ 0 ]; do
	reset
	dialog --title " $TITLE" \
        --menu "Group Menu" 12 50 4 \
        "1" "List Groups" \
        "2" "Add a Group" \
        "3" "Delete a Group" \
        "4" "QUIT to Security Menu" 2> /tmp/gch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/gch.tmp.$$
                exit
        fi
        gchoice=`cat /tmp/gch.tmp.$$`
        /bin/rm -f /tmp/gch.tmp.$$
        if [ "$gchoice" = "1" ]; then
	cat /etc/group > /tmp/tgrp.$$
	dialog --title "`hostname`'s Groups" \
	--textbox /tmp/tgrp.$$ 18 50 
	/bin/rm -f /tmp/tgrp.$$        
        fi
        if [ "$gchoice" = "2" ]; then
        add-grp
        fi
	if [ "$gchoice" = "3" ]; then
        del-grp
        fi
        if [ "$gchoice" = "Q" ]; then
        secmain
        fi
done
}

smain()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "System Menu" 15 40 8 \
        "1" "Memory Status" \
        "2" "File Systems Status" \
	"3" "System Load" \
        "4" "System Proc Info" \
	"5" "User Status"\
	"6" "FileSystem Maintainance" \
	"7" "Backup & Restore" \
        "Q" "QUIT to Main Menu" 2> /tmp/sch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/sch.tmp.$$
                exit
        fi
        schoice=`cat /tmp/sch.tmp.$$`
        /bin/rm -f /tmp/sch.tmp.$$

        if [ "$schoice" = "1" ]; then
        free > /tmp/free.tmp.$$
	dialog --title " Memory Stats" \
        --textbox /tmp/free.tmp.$$ 18 70 
	/bin/rm -f /tmp/free.tmp.$$
        fi

        if [ "$schoice" = "2" ]; then
	dfck > /tmp/df.$$
        dialog --title " Filesystem Stats" \
        --textbox /tmp/df.$$ 18 76
	/bin/rm -f /tmp/df.$$
        fi
	if [ "$schoice" = "3" ]; then
        /usr/local/bin/load > /tmp/sysload.$$
        dialog --title " System Load" \
        --textbox /tmp/sysload.$$ 18 46
        /bin/rm -f /tmp/sysload.$$
        fi

	if [ "$schoice" = "4" ]; then
        procinfo > /tmp/sproc.tmp.$$
        dialog --title "System Processes Information" \
        --textbox /tmp/sproc.tmp.$$ 18 76
        /bin/rm -f /tmp/sproc.tmp.$$
        fi

        if [ "$schoice" = "5" ]; then
        users > /tmp/users.tmp.$$
        dialog --title "System Users" \
        --textbox /tmp/users.tmp.$$ 18 76
        /bin/rm -f /tmp/users.tmp.$$
        fi

	if [ "$schoice" = "6" ]; then
	fsmaint
        fi

	if [ "$schoice" = "7" ]; then
	/usr/local/bin/lbu
	fi

        if [ "$schoice" = "Q" ]; then
        main
        fi
done
}

nmenu()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Network Menu" 14 40 7 \
        "1" "Network Status" \
	"2" "Network Accounts Activity" \
	"3" "Check ARP Tables" \
        "4" "Ping a system" \
	"5" "Check Kernel Routing Table" \
        "Q" "QUIT to Main Menu" 2> /tmp/nch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/nch.tmp.$$
                exit
        fi
	nchoice=`cat /tmp/nch.tmp.$$`
        /bin/rm -f /tmp/nch.tmp.$$
        if [ "$nchoice" = "1" ]; then
        netstat > /tmp/nstat.tmp.$$
        dialog --title " Network Stats" \
        --textbox /tmp/nstat.tmp.$$ 18 70
        /bin/rm -f /tmp/nstat.tmp.$$
        fi

        if [ "$nchoice" = "2" ]; then
        ifconfig > /tmp/ifc.$$
        dialog --title " Check IP Address" \
        --textbox /tmp/ifc.$$ 18 76
        /bin/rm -f /tmp/ifc.$$
        fi
        if [ "$nchoice" = "3" ]; then
        /sbin/arp -a > /tmp/arp.tmp.$$
        dialog --title "Look at ARP Table for $HOSTNAME" \
        --textbox /tmp/arp.tmp.$$ 18 70
        /bin/rm -f /tmp/arp.tmp.$$
        fi
        if [ "$nchoice" = "4" ]; then
	dialog --title "Get address to Ping" \
	--inputbox "What IP address to PING?" 10 70 2> /tmp/tmp.msg.$$
	Paddr=`cat /tmp/tmp.msg.$$`
	/bin/rm -f /tmp/tmp.msg.$$
        ping -c 10 $Paddr > /tmp/ping.tmp.$$
        dialog --title "Pinging $Paddr" \
        --textbox /tmp/ping.tmp.$$ 18 76
        /bin/rm -f /tmp/ping.tmp.$$
        fi
        if [ "$nchoice" = "5" ]; then
        /sbin/route -n > /tmp/krt.$$
        dialog --title " Kernel Routing Table" \
        --textbox /tmp/krt.$$ 18 78
        /bin/rm -f /tmp/krt.$$
        fi	
        if [ "$nchoice" = "Q" ]; then
        main
        fi
done
}

utils()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Utilities Menu" 14 50 6 \
        "1" "Check & Edit System Processes" \
        "2" "File Manager" \
        "3" "System News Editor" \
        "4" "Edit CRONTABS" \
	"5" "TeX MGR - Process .tex, .dvi & .ps files" \
        "Q" "QUIT to Main Menu" 2> /tmp/util.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/util.tmp.$$
                exit
        fi
        utilch=`cat /tmp/util.tmp.$$`
        /bin/rm -f /tmp/util.tmp.$$
        if [ "$utilch" = "1" ]; then
        gitps
        fi
        if [ "$utilch" = "2" ]; then
        git
        fi
        if [ "$utilch" = "3" ]; then
        news-edt
        fi
        if [ "$utilch" = "4" ]; then
        cron-edt
        fi
	if [ "$utilch" = "5" ]; then
        texmgr
        fi
        if [ "$utilch" = "Q" ]; then
        main
        fi

done
}

leave()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Prepare Admin.Log" 12 45 3 \
        "1" "View Admin.Log" \
        "2" "Update Admin.Log" \
        "Q" "QUIT" 2> /tmp/mych.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/mych.tmp.$$
                exit
        fi
        lchoice=`cat /tmp/mych.tmp.$$`
        /bin/rm -f /tmp/mych.tmp.$$

 	if [ "$lchoice" = "1" ]; then
        dialog --title " $TITLE"\
        --textbox /var/adm/Admin.Log 18 70
        /bin/rm -f /tdoneron.tmp.$$
        fi

	if [ "$lchoice" = "2" ]; then
	$AEDIT /var/adm/Admin.Log
	fi

        if [ "$lchoice" = "Q" ]; then
	clear
        exit
        fi
done
}

add-user()
{
while [ 0 ]; do
	dialog --title "Add A New User" \
	--inputbox "New Users LOGIN Name (at least 6 Chars):" 10 70 2> /tmp/user.tmp.$$
	UserName=`cat /tmp/user.tmp.$$`
	/bin/rm -f /tmp/user.tmp.$$
 
        dialog --title "Add A New User" \
        --inputbox "$UserName's Full Name:" 10 70 2> /tmp/fuser.tmp.$$
        FNAME=`cat /tmp/fuser.tmp.$$`
        /bin/rm -f /tmp/fuser.tmp.$$
	LUID=`tail -1 /etc/passwd | cut -f3 -d:` 
	NUID=`expr $LUID + 1`
        dialog --title "Add A New User" \
        --msgbox "$UserName's ID (number) is:$NUID" 10 70	
	 
        dialog --title "Add A New User" \
        --inputbox "$UserName's Group ( hit ENTER for default group \
of USERS (100)):" 10 75 2> /tmp/guser.tmp.$$
	if [ "`cat /tmp/guser.tmp.$$`" = "" ]; then
	  NGID="100"
	else
          NGID=`cat /tmp/guser.tmp.$$`
	fi
        /bin/rm -f /tmp/guser.tmp.$$
 
        dialog --title "Add A New User" \
        --inputbox "$UserName's Home Directory: \
Hit ENTER for default:/home/users/$UserName " 10 75 2> /tmp/duser.tmp.$$
	if [ "`cat /tmp/duser.tmp.$$`" = "" ]; then
          HDIR=/home/users/$UserName 
        else
          HDIR=`cat /tmp/duser.tmp.$$`
	fi
        /bin/rm -f /tmp/duser.tmp.$$
 
        dialog --title "Add A New User" \
        --inputbox "$UserName's Shell \
(Hit ENTER for default:/bin/bash)" 10 70 2> /tmp/suser.tmp.$$
        if [ "`cat /tmp/suser.tmp.$$`" = "" ]; then
          NSHELL=/bin/bash
        else
        NSHELL=`cat /tmp/suser.tmp.$$`
	fi
        /bin/rm -f /tmp/suser.tmp.$$


	dialog --title "Add A New User" \
        --yesno "	New User: $UserName \n
	Full Name: $FNAME \n
	UID: $NUID \n
	GID: $NGID \n
	Home Dir: $HDIR \n
	Shell: $NSHELL " 16 50
	case $? in
  		0)
		  echo $UserName"::"$NUID":"$NGID":"$FNAME":"$HDIR":"$NSHELL >>$EPWORD
		  echo "`date` - $UID added user:$UserName" >>/var/adm/Admin.Log
	          echo $UserName"::"$NUID":"$NGID":"$FNAME":"$HDIR":"$NSHELL >>/var/adm/Admin.Log
		  mkdir $HDIR
		  cp  /etc/skel/.* $HDIR
        	  chown -R $UserName.$NGID $HDIR 
		  touch $UMAIL/$UserName
		  chown -R $UserName.mail $UMAIL/$UserName
		  umain ;;
       		1)
		    umain ;;
  		255)
    		    echo "ESC pressed."  
		    umain ;;
	esac
done
}

del-user()
{
while [ 0 ]; do
	dialog --title "Delete User(s)" \
	--inputbox "What user to be removed?" 10 50 2> /tmp/duser.tmp.$$
	DUSER=`cat /tmp/duser.tmp.$$`
		if [ $DUSER = " " ]; then
		   gmain
		fi
		/bin/rm /tmp/duser.tmp.$$
		pwget -x -n $DUSER > /tmp/DU.tmp.$$
		HDIR=`pwget -n $DUSER -f '%d'`
		/bin/cp /tmp/DU.tmp.$$ $EPWORD
		
		sed s/,$DUSER\$// <$EGROUP | sed s/\\:$DUSER\$/\\:/ | sed s/,$DUSER,/,/ | \
		sed s/\\:$DUSER,/\\:/ > /tmp/DU.tmp.$$
		/bin/cp /tmp/DU.tmp.$$ $EGROUP
		/bin/rm -rf $HDIR
		/bin/rm -f $UMAIL/$DUSER
		/bin/rm -f /tmp/DU.tmp.$$
		echo "`date` - $UID deleted User:$DUSER" >> /var/adm/Admin.Log
		checkusers >> /var/adm/Admin.Log
		umain	
done
}

add-grp()
{
while [ 0 ]; do
	dialog --title "Add A Group" \
	--inputbox "Groupname to add:" 8 50 2> /tmp/ngrp.tmp.$$
	NGRP=`cat /tmp/ngrp.tmp.$$`
	/bin/rm /tmp/ngrp.tmp.$$
	dialog --title "Add A Group" \
	--inputbox "GroupID:" 8 50 2> /tmp/ngid.tmp.$$
	NGID=`cat /tmp/ngid.tmp.$$`
	/bin/rm /tmp/ngid.tmp.$$
	dialog --title "Add A Group" --clear \
	--yesno "Assign $NGRP a password? (y/N)" 8 50

	case $? in
		0)
			clear
			getpass 1>/tmp/npw.tmp.$$
			PWORD=`cat /tmp/npw.tmp.$$`
			/bin/rm -f /tmp/npw.tmp.$$;;
		1)
			PWORD='';;

	esac

	dialog --title "Add A Group" \
	--msgbox "Now Adding new group $NGRP" 8 50 
	echo $NGRP":"$PWORD":"$NGID":" >> $EGROUP
	echo "`date` - $UID added group:$NGRP:$P1WORD:$NGID: " >>/var/adm/Admin.Log

gmain	
done
}

del-grp()
{
while [ 0 ]; do
	dialog --title "Delete a Group" \
	--inputbox "Which group to delete?" 8 50 2> /tmp/dgrp.tmp.$$
	DGRP=`cat /tmp/dgrp.tmp.$$`
	/bin/rm -f /tmp/dgrp.tmp.$$
	dialog --title "Delete a Group" \
	--msgbox "Deleting group $DGRP" 8 50
	echo "`date` - $UID deleted group: $DGRP" >>/var/adm/Admin.Log
	grget -n $DGRP -x >/tmp/DG.tmp.$$
	/bin/cp /tmp/DG.tmp.$$ $EGROUP
	/bin/rm -f /tmp/DG.tmp.$$
	gmain
done
}		

cron-edt()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Edit CRONTAB Files" 12 50 3 \
        "1" "List crontab files" \
        "2" "Edit a file" \
        "Q" "QUIT to Main Menu" 2> /tmp/cech.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/cech.tmp.$$
                main
        fi
        cechoice=`cat /tmp/cech.tmp.$$`
        /bin/rm -f /tmp/cech.tmp.$$

        if [ "$cechoice" = "1" ]; then
        /bin/ls /var/spool/cron/crontabs > /tmp/cront.tmp.$$
        dialog --title "`hostname`'s CRONTAB Files" \
        --textbox /tmp/cront.tmp.$$ 18 70
        /bin/rm -f /tmp/cront.tmp.$$
        fi

        if [ "$cechoice" = "2" ]; then
        cd /var/spool/cron/crontabs
 	dialog --title "SCANNING" \
	--infobox "Please wait while I look for files." 7 40
	echo 'dialog --menu "Please select the file to edit." 15 45 8 \'> /tmp/viewscr$$
        if [ "`ls /var/sysnews/* 2>/dev/null`" = "" ]; then
                dialog --title "NO FILE FOUND" \
                --msgbox "No files found." 10 30
        else
                /bin/ls *|sed -e '/*/s///'|sed -e 's/.*/"&" "" \\/' >> /tmp/viewscr$$
                echo "2> /tmp/return\$\$" >> /tmp/viewscr$$
                while [ 0 ]; do
                        source /tmp/viewscr$$
                        if [ ! "`cat /tmp/return$$`" = "" ]; then
                                EDTFILE=`cat /tmp/return$$`
                                break
                        else
                EDTFILE=`cat /tmp/return$$`
                        fi
                done
                /bin/rm -f /tmp/return$$ /tmp/viewscr$$ /tmp/tmpmsg.$$
        fi
        $AEDIT /var/spool/cron/crontabs/$EDTFILE
        cd /
        fi
        if [ "$cechoice" = "Q" ]; then
        utils
        fi
done
}

news-edt()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Edit the System News Files" 12 50 4 \
        "1" "List news files" \
        "2" "Edit a file" \
        "3" "Run News" \
        "Q" "QUIT to Main Menu" 2> /tmp/nech.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/nech.tmp.$$
                exit
        fi
        nechoice=`cat /tmp/nech.tmp.$$`
        /bin/rm -f /tmp/nech.tmp.$$

        if [ "$nechoice" = "1" ]; then
        /bin/ls /var/sysnews > /tmp/news.tmp.$$
        dialog --title "`hostname`'s News Files" \
        --textbox /tmp/news.tmp.$$ 18 70
        /bin/rm -f /tmp/news.tmp.$$
        fi

        if [ "$nechoice" = "2" ]; then
	cd /var/sysnews
	dialog --title "SCANNING" --infobox "Please wait while I look for files." 7 40    
	echo 'dialog --menu "Please select the file to edit." 15 45 8 \'> /tmp/viewscr$$
	if [ "`ls /var/sysnews/* 2>/dev/null`" = "" ]; then
	        dialog --title "NO FILE FOUND" \
        	--msgbox "No files found." 10 30
   	else
        	ls *|sed -e '/*/s///'|sed -e 's/.*/"&" "" \\/' >> /tmp/viewscr$$
        	echo "2> /tmp/return\$\$" >> /tmp/viewscr$$
        	while [ 0 ]; do
                	source /tmp/viewscr$$
                	if [ ! "`cat /tmp/return$$`" = "" ]; then
                        	EDTFILE=`cat /tmp/return$$`
                        	break
                	else
        	EDTFILE=`cat /tmp/return$$`
                	fi
        	done
        	/bin/rm -f /tmp/return$$ /tmp/viewscr$$ /tmp/tmpmsg.$$
	fi
	$AEDIT /var/sysnews/$EDTFILE
	cd /
        fi
        if [ "$nechoice" = "3" ]; then
        news > /tmp/snews.tmp.$$
        dialog --title "System News" \
        --textbox /tmp/snews.tmp.$$ 18 76
        /bin/rm -f /tmp/snews.tmp.$$
        fi
        if [ "$nechoice" = "Q" ]; then
        utils
        fi
done
}

prnt-mgmt()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Print Queue Management" 18 60 11 \
        "status" "Check Print Queue status" \
        "kill" "Kill a Print Job" \
        "clean" "Clean All Print Queues" \
	"stop" "Turn off Printing" \
	"start" "Turn on Printing"\
	"down" "Down a Queue and notify Users" \
	"up" "Up a previously downed Queue" \
	"topq" "Reorder Jobs in a Queue" \
	"stopall" "Stop ALL QUEUES" \
	"startall" "Start ALL QUEUES" \
	"exit" "Exit to Main Menu" 2> /tmp/pmch.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/pmch.tmp.$$
                exit
        fi
        pmchoice=`cat /tmp/pmch.tmp.$$`
        /bin/rm -f /tmp/pmch.tmp.$$
        if [ "$pmchoice" = "status" ]; then
        lpc status > /tmp/qstat.tmp.$$
        dialog --title "Queue Status" \
        --textbox /tmp/qstat.tmp.$$ 18 70
        /bin/rm -f /tmp/qstat.tmp.$$
        fi
        if [ "$pmchoice" = "kill" ]; then 
	que_list
	proc_list
	lprm $WFILE -P$PQUE
        fi
        if [ "$pmchoice" = "clean" ]; then
        lpc clean all
        fi
	if [ "$pmchoice" = "stop" ]; then
	que_list
	lpc stop $PQUE
	dialog --title "Queue Status" \
	--msgbox "$PQUE stopped" 8 50
	fi
	if [ "$pmchoice" = "start" ]; then
	que_list
	lpc start $PQUE
 	fi
	if [ "$pmchoice" = "down" ]; then
        que_list
        lpc down $PQUE
        fi
	if [ "$pmchoice" = "up" ]; then
        que_list
        lpc up $PQUE
        fi
        if [ "$pmchoice" = "topq" ]; then
        que_list
	proc_list
        lpc topq $PQUE $WFILE
        fi
	if [ "$pmchoice" = "stopall" ]; then
        lpc down all > /tmp/stall.$$ 
	/bin/rm -f /tmp/stall.$$
        fi
	if [ "$pmchoice" = "startall" ]; then
        lpc up all > /tmp/stall.$$ 
	/bin/rm -f /tmp/stall.$$
        fi
	if [ "$pmchoice" = "exit" ]; then
        main
        fi
done
}

que_list()
{
   reset
   dialog --title "SCANNING" --infobox "Please wait while I look for files." 7 45
   echo 'dialog --menu "Please select the file to edit." 15 78 12 \'> /tmp/que.$$
   if [ "`cat /etc/pqueues 2>/dev/null`" = "" ]; then
   	dialog --title "NO FILE FOUND" \
   	--msgbox "No Queues Found!" 10 30
	exit
   else

        cat /etc/pqueues |sed -e '/*/s///'|sed -e 's/.*/"&" "" \\/' >> /tmp/que.$$
        echo "2> /tmp/qreturn\$\$" >> /tmp/que.$$
        while [ 0 ]; do
                source /tmp/que.$$
                if [ ! "`cat /tmp/qreturn$$`" = "" ]; then
                        PQUE=`cat /tmp/qreturn$$`
                        break
                else
                        break
                fi
        done
   fi
/bin/rm -f /tmp/qreturn$$ /tmp/que.$$
}

proc_list()
{
   CMD="lpq -P$PQUE"
   dialog --title "Looking in $PQUE" --infobox "Please wait while I look." 7 45
   echo 'dialog --menu "Please select the job." 15 78 12 \'> /tmp/viewscr$$
   if [ "`$CMD 2>/dev/null`" = "" ]; then
   dialog --title "NO QUEUE FOUND" \
        --msgbox "No queues found." 10 30
   else
    	$CMD|sed -e '/*/s///'|sed -e 's/.*/"&" "" \\/' >> /tmp/viewscr$$
        echo "2> /tmp/return\$\$" >> /tmp/viewscr$$
        while [ 0 ]; do
                source /tmp/viewscr$$
                if [ ! "`cat /tmp/return$$`" = "" ]; then
			cut -c19-23 /tmp/return$$ > /tmp/edit.$$
                        WFILE=`cat /tmp/edit.$$`
			dialog --title "Job to Delete" \
			--textbox /tmp/edit.$$  8 50
                        break
                else
                        break
                fi
	done
   fi
/bin/rm -f /tmp/return$$ /tmp/viewscr$$ /tmp/tmpmsg.$$ /tmp/edit.$$
}

fsmaint()
{
while [ 0 ]; do
	reset
        dialog --title " $TITLE" \
        --menu "Filesystem Maintainance" 14 60 6 \
        "H" "FS Hints & Tips - Help Text" \
	"1" "Check USER Directories" \
        "2" "Find Duplicate files (/bin /usr/bin)" \
	"3" "Send duplicate files list to printer" \
        "4" "Compress Log Files (syslog, wtmp, utmp & messages)" \
        "Q" "QUIT to Main Menu" 2> /tmp/mych.tmp.$$
        if [ $? = 1 -o $? = 255 ]; then
                /bin/rm -f /tmp/tmpmsg.$$ /tmp/mych.tmp.$$
                exit
        fi
        nchoice=`cat /tmp/mych.tmp.$$`
        /bin/rm -f /tmp/mych.tmp.$$
        if [ "$nchoice" = "H" ]; then
        dialog --title "`hostname`'s Filesystem" \
        --textbox /var/lib/admin/fs.text 18 70
        fi
	if [ "$nchoice" = "1" ]; then
        dialog --title "User Space Check" \
	--infobox "Please wait... " 5 50
	/usr/sbin/usrdsksp 
	dialog --title "`hostname`'s Users" \
        --textbox /tmp/user.chk 18 70
	/bin/rm -f /tmp/user.chk 
	fi
        if [ "$nchoice" = "2" ]; then
	dialog --title "SCANNING" --infobox "Please wait... looking for duplicate files." 7 60    
	/usr/bin/diff -s /bin /usr/bin >/tmp/diff.tmp
	/bin/touch /tmp/diff.files
	/usr/bin/grep "Files" /tmp/diff.tmp >>/tmp/diff.files
	/bin/rm /tmp/diff.tmp
	dialog --title " $TITLE" \
	--textbox /tmp/diff.files 20 75
        fi
        if [ "$nchoice" = "3" ]; then
        /usr/bin/lpr /tmp/diff.files
	/bin/rm /tmp/diff.files
        fi
        if [ "$nchoice" = "4" ]; then
        dialog --title "Log Maintainance" \
	--infobox "Compressing files and building new files.. Please Wait." 5 60
	/bin/gzip -f /var/adm/wtmp /var/adm/utmp /var/adm/messages /var/adm/syslog
	/bin/touch /var/adm/messages /var/adm/wtmp /var/adm/utmp /var/adm/syslog
        fi
	if [ "$nchoice" = "Q" ]; then
        smain
        fi
done
}

logins()
{
SRC_FILE=/usr/adm/logins

IFS="."
sort +1 +0 +3 -t"." $SRC_FILE | while read DIRECTION USER TTY DATE
do
   echo "$DIRECTION $USER $TTY $DATE"
done
}

if [ $log_name != "root" ]; then
   dialog --msgbox "You got to be the SUPERUSER to run!" 5 50
   else
   cp /etc/passwd $PWBACK
   cp /etc/group $GRPBACK
   main
fi

if [ $log_group != "adm" ]; then
   dialog --msgbox "You got be Administrative to run!" 5 50
   else
   cp /etc/passwd $PWBACK
   cp /etc/group $PWBACK
   main
fi

