#!/bin/sh
#
# m_sac_s.sh - monthly accounting report (short form)
#
# usage: m_sac.sh <month> [username]
#

ISPUTIL=/var/lib/ISPutil

AWK=/usr/bin/awk
SAC=/usr/local/bin/sac
m=$1
u=$2
if [ -z $u ]; then
  u=$USER
  if [ -z $u ]; then
    u=$LOGNAME
  fi
fi
echo "--------------------------------------"
echo "mountnet.com short modem usage report."
echo "--------------------------------------"
echo
echo "Username: $u"
echo
echo "Reported: "`date`
echo
$SAC -d -T ttyS0 ttyS1 ttyS2 ttyS3 \
	ttyS16 ttyS17 ttyS18 ttyS19 ttyS20 ttyS21 ttyS22 ttyS23 \
	ttySA ttySB ttySC ttySD ttySE ttySF ttySG ttySH \
	ttySI ttySJ ttySK ttySL ttySM ttySN ttySO ttySP \
	-u $u | $AWK -f $ISPUTIL/sac/m_sac.awk -v month=$m
