#!/bin/sh
#
# m_sac - monthly accounting report
#
# usage: m_sac <month> [username]
#

ISPUTIL=/var/lib/ISPutil

AWK=/usr/bin/awk
LAST=/usr/bin/last
SAC=/usr/local/bin/sac
m=$1
u=$2
if [ -z $u ]; then
  u=$USER
  if [ -z $u ]; then
    u=$LOGNAME
  fi
fi
echo "--------------------------------"
echo "mountnet.com modem usage report."
echo "--------------------------------"
echo
echo "Username: $u"
echo
echo "Reported: "`date`
echo
echo "------------------------------"
echo "Modem logins for month of ${m}."
echo "------------------------------"
echo "Server   Port    Date                       Time"
$LAST $u | $AWK "/ttyS.*$m/ { print \"dialup1\t \" \$2 \"\\t\" substr(\$0,40,80) }"
echo
echo "Note: the above login times are rounded to minutes so they"
echo "      may not appear to precisely agree with figures below."
echo "      (Above is hours:minutes, below is hours.decimals.)"
echo
$SAC -d -T ttyS0 ttyS1 ttyS2 ttyS3 \
	ttyS16 ttyS17 ttyS18 ttyS19 ttyS20 ttyS21 ttyS22 ttyS23 \
	ttySA ttySB ttySC ttySD ttySE ttySF ttySG ttySH \
	ttySI ttySJ ttySK ttySL ttySM ttySN ttySO ttySP \
	-u $u | $AWK -f $ISPUTIL/sac/m_sac.awk -v month=$m
