#!/bin/sh
#
# nameinuse.sh -	Return error if username clashes with aliases etc
#

ISPUTIL="/var/lib/ISPutil"
ISPDBS="/var/lib/ISPutil/qdDBs"
CLIENTSDB=$ISPDBS/Clients
QBIN="/usr/local/qddb/bin"
QUERY=$QBIN/query
LISTSDIR=/etc/smail/lists


if [ "$1" = "" ]; then
  echo 'Usage: nameinuse.sh <username>'
  exit 0
fi

used=""

function usedas() {
  echo $name already exists as $*
  used="$*"
  exit 1
}

name="$1"

grep "^$name:" /etc/passwd && usedas username
grep "^$name " /etc/smail/forward >/dev/null \
	&& usedas forwarded username
grep "^$name:" /etc/aliases && usedas email alias
if [ -f $LISTSDIR/$name ]; then
  usedas a mailing list
fi
grep "^$name:" /etc/gecosaliases && usedas email alias
grep "^$name:" /etc/morealiases && usedas email alias
grep "^$name\$" /var/lib/majordomo/lists/users >/dev/null \
	 && usedas users list subscriber
u=""
u=`$QUERY $CLIENTSDB -sep ' ' Company.Contact.Username $name \
	-print Company.Contact.Username`
if [ "$u" != "" ]; then
  usedas Clients Database record 
fi
grep "^$name\$" >/dev/null /var/lib/ISPutil/badnames.txt \
	&& usedas disallowed name

if [ "$used" != "" ]; then
  exit 1
else
  echo $name available.
  exit 0
fi
