#!/bin/sh
#
# makeuser.sh -	Create a user with timelimits
#
#	Usage:	makeuser <user> <GID> <EXPIRY> <TIME> <SESSION> \
#			<PRIORITY> <SHELL> <real name is remaining fields>
#

MODEMHOST=god
ACCOUNTS_SUPDIST=knotshare
SUPFILE=/root/cmds/supfile

BBSUTIL="/var/lib/BBSutil"
ISPUTIL="/var/lib/ISPutil"
GETUID="$ISPUTIL/bin/id -u"
SUPER=/usr/bin/super
NAMEINUSE=$ISPUTIL/bin/nameinuse.sh
#USER_ADDREC="rsh $MODEMHOST $BBSUTIL/user_addrec"
USER_ADDREC="$BBSUTIL/user_addrec"
GREP=/usr/bin/grep
SED=/usr/bin/sed
#UPDTMODEMHOST="rsh $MODEMHOST $SUPER sup -bdev $SUPFILE $ACCOUNTS_SUPDIST"
UPDTMODEMHOST="echo Nothing to do to update modemhost"

user=$1 ; shift
DEFAULT_GID=$1; shift
DEFAULT_EXPIRY=$1; shift
DEFAULT_TIME=$1; shift
DEFAULT_SESSION=$1; shift
DEFAULT_PRIORITY=$1; shift
DEFAULT_SHELL=$1; shift
fullname="$*"

$NAMEINUSE $user 2>/dev/null || exit 1

echo $user $DEFAULT_GID $DEFAULT_EXPIRY $DEFAULT_TIME $DEFAULT_SESSION \
	$DEFAULT_PRIORITY $DEFAULT_SHELL "$*"

echo Creating user...
$SUPER useradd -c "$fullname" -m -g $DEFAULT_GID \
	-s $DEFAULT_SHELL  $user  \
	|| exit 1
echo Correcting homedir permissions...
$SUPER fixhomeperms $user
echo Setting Temporary password...
$GREP ^$user: /etc/passwd \
	| $SED -e "s/^$user:x:/$user:Temporary:/" | $SUPER newusers

echo Updating Modemhost...
$UPDTMODEMHOST
echo Setting user timelimits...
$USER_ADDREC `$GETUID $user` $DEFAULT_EXPIRY $DEFAULT_TIME \
	$DEFAULT_SESSION $DEFAULT_PRIORITY

exit 0
