#
# This ugly hack is needed because qddb doesn't filter
# out previous updates; meaning, there could be two tuples
# if there was a tuple update performed since last
# stabilization
#
proc isUniqueTuple { k s } {
    set rv ""
    set count 0
    foreach i $k {
	set t [qddb_tuple read $s $i]
	if { $t != "" } {
	    set rv $t
	    incr count
	}
    }
    if { $count != 1 } { return "" } { return $rv }
}

#
# currency_format { amt how }
#     amt ...... must be a valid number or bad things will happen
#     how ...... TRUNCATE, ROUNDUP, or ANYTHINGELSE
proc currency_format { amt how } {
    set rv [format "%12.3f" $amt]
    set dot [string first . $rv]
    set a [string range $rv 0 [expr $dot+1]]
    set b [string index $rv [expr $dot+2]]
    set c [string index $rv [expr $dot+3]]
    if { $how == "TRUNCATE" } {
	return [string trim $a$b " "]
    } elseif { $how == "ROUNDUP" } {
	if { $c == 0 } { 
	    return [string trim $a$b " "]
	} else { 
	    incr b 
	    if { $b == 0 } { incr a }
	    return [string trim $a$b " "]
	}
    } else { 
	if { $c > 5 } { 
	    incr b 
	    if { $b == 0 } { incr a }
	    return [string trim $a$b " "]
	}
	return [string trim $a$b " "]
    }
}

proc isnumber { n } {
    if {[catch [list expr double($n)]] != 0} {
	return 0
    } else {
	return 1
    }
}

proc old_isnumber { n } {
    if { $n == "" } { return 0 }
    regexp {^[0-9]*\.?[0-9]*$} [string trim $n " "]
}

proc MsgBox { title lines w } {
    toplevel .$w
    wm title .$w $title
    set x .$w.buttons
    frame $x
    pack $x -side bottom -fill x
    button $x.ok -text "Ok" -command "destroy .$w"
    pack $x.ok -fill x

    set x .$w.f
    frame $x
    pack $x -side top -expand on -fill both
    scrollbar $x.s -orient vertical -relief sunken -command [list $x.c yview]
    pack $x.s -side right -fill y
    text $x.c -relief sunken -bd 2 -yscroll [list $x.s set] -wrap word -setgrid on
    pack $x.c -side left -expand on -fill both
    set count 0
    foreach i $lines {
	$x.c insert end $i
	$x.c insert end "\n"
	incr count
    }
    $x.c configure -state disabled
}


proc doPrint {fn {title {Printer Selection}}} {
    global fx_config {fx:status_variable} fx_blt

    if {[winfo exists .invoice_out]} {
	Fx_PrintDialog print_dialog -title $title -toplevel .invoice_out
    } else {
	Fx_PrintDialog print_dialog -title $title
    }
    if {$fx_config(cancel_print) == 0} {
	catch "Fx:PrintFile $fn"
    } else {
	set fx:status_variable "Printing cancelled."
    }
}

