# ----------------------------------------------------------------------
#  PURPOSE:  drag&drop send routine for "inventory" data
#
#  Widgets that are to participate in drag&drop operations for
#  "text" data should be registered as follows:
#
#      drag&drop .win source handler text dd_send_text
#      drag&drop .win target handler text my_text_handler
#
#      proc my_text_handler {} {
#          global DragDrop
#
#          set data $DragDrop(text)
#            .
#            .  do something with $data
#            .
#      }
#
#   AUTHOR:  Michael J. McLennan       Phone: (215)770-2842
#            AT&T Bell Laboratories   E-mail: aluxpo!mmc@att.com
#
#   Modified by:
#       Gilbert Benson   02/12/95   Inclusion into SE application for 
#                                   dropping inventory items onto invoice
#
#     SCCS:  %W% (%G%)
# ----------------------------------------------------------------------
#            Copyright (c) 1993  AT&T  All Rights Reserved
# ======================================================================

# ----------------------------------------------------------------------
# COMMAND: dd_send_inventory <interp> <ddwin> <data>
#
#   INPUTS
#     <interp> = interpreter for target application
#      <ddwin> = pathname for target drag&drop window
#       <data> = data returned from -tokencmd
#
#   RETURNS
#     ""
#
#   SIDE-EFFECTS
#     Sends data to remote application DragDrop(inventory), and then
#     invokes the "inventory" handler for the drag&drop target.
# ----------------------------------------------------------------------
proc dd_send_inventory {interp ddwin data} {
	send $interp "
		global DragDrop
		set DragDrop(inventory) [list $data]
	"
	send $interp "blt_drag&drop target $ddwin handle inventory"
}
