#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <syslog.h>
#include <strings.h>

#define	SESSREG	"/usr/bin/sessreg"

void set_handler();
void handle_signals(int signal);

struct passwd *pwrec;


int main (int argc, char **argv)
{
	char salt[3], *upass, *cpass;
	char cmdbuf[256];
	int i;

	openlog("pwdoas", (int)0, LOG_AUTHPRIV);
	if (argc < 3) {
		printf("Usage: ISPlogin <username> <command> [arg ... arg]\n");
		exit (1);
	}
	pwrec = getpwnam(argv[1]);
	upass = getpass("Password: ");
	if (pwrec != NULL) {
		strncpy(salt,pwrec->pw_passwd,2);
		cpass = crypt(upass,salt);
		if (strcmp(cpass,pwrec->pw_passwd) ==0) {
			sprintf(cmdbuf,"%s -a %s",SESSREG,pwrec->pw_name);
			system(cmdbuf);
			set_handler();
			setuid(pwrec->pw_uid);
			*cmdbuf = '\0';
			for (i=2; i<argc; i++) {
				strcat(cmdbuf,argv[i]);
				strcat(cmdbuf," ");
			}
			system(cmdbuf);
			sprintf(cmdbuf,"%s -d %s",SESSREG,pwrec->pw_name);
			system(cmdbuf);
			exit (0);
		}
		syslog(LOG_NOTICE,"1 LOGIN FAILURE on %s, %s",
			ttyname(1), argv[1]);
	}
	printf("Login incorrect\n\n");
	exit(1);
}


void set_handler()
{
	signal(SIGHUP,handle_signals);
}


void handle_signals(int signal)
{
	set_handler();
	system("%s -d %s",SESSREG,pwrec->pw_name);
	exit (0);
}

