/* Mitch Dsouza, <m.dsouza@mrc-apu.cam.ac.uk> 1-2-94 */

#include <stdio.h>
#include <unistd.h>

#ifdef NLS
#include <nl_types.h>
#include <locale.h>
#include "hostid.h"
#endif

void main (int argc, char **argv)
{
	extern int errno;
#ifdef NLS
	nl_catd msg_cat;

	setlocale(LC_MESSAGES,"");
	msg_cat=catopen("hostid",MCLoadAll);
#endif

	if (argc==2)
	{
		if (sethostid(atoi(argv[1]))!=0)
#ifdef NLS
			printf(catgets(msg_cat,HostIDSet, HostID1,
				       "Hostid may only be set by the superuser\n"));
#else
			printf("Hostid may only be set by the superuser\n");
#endif
	} else if (argc==1) {
		unsigned id;

		if (id=gethostid())
#ifdef NLS
			printf(catgets(msg_cat,HostIDSet, HostID2,
				       "Hostid is %u (0x%x)\n"),id,id);
#else
			printf("Hostid is %u (0x%x)\n");
#endif
		else
#ifdef NLS
			printf(catgets(msg_cat,HostIDSet, HostID3,
				       "Hostid is unset\n"));
#else
			printf("Hostid is unset\n");
#endif
	} else
#ifdef NLS
		printf(catgets(msg_cat,HostIDSet, HostID4,
			       "Usage: %s hostid_number\n"),*argv);
#else
		printf("Usage: %s hostid_number\n");
#endif
}
