#include <gtk/gtk.h>

GtkWidget *check_r;
GtkWidget *check_c;
GtkWidget *check_n;
GtkWidget *check_x;
GtkWidget *check_d;
GtkWidget *check_w;
GtkWidget *check_l;
GtkWidget *check_e;
GtkWidget *check_u;
GtkWidget *check_o;
GtkWidget *entry_file1;
GtkWidget *entry_passwd;
GtkWidget *spinner_layers;
GtkWidget *adj;

void file_ok_infile( GtkWidget *widget,
                     GtkFileSelection *fs )
{
    gtk_entry_set_text( GTK_ENTRY( entry_file1 ), gtk_file_selection_get_filename( GTK_FILE_SELECTION(fs)));
}


void browse_infile( GtkWidget *widget,
                    gpointer data )
{
    GtkWidget *filesel;
    filesel = gtk_file_selection_new( "Input file selection" );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
                        "clicked", (GtkSignalFunc) file_ok_infile, filesel );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));
    
    gtk_widget_show( filesel );
}

void failed( void )
{
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *button;
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    table = gtk_table_new( 1, 2, FALSE );
    label = gtk_label_new( "The operation failed ;o[, change to the console,\n where you startet me from, to find out why" );
    button = gtk_button_new_with_label( "Close" );
    gtk_container_set_border_width( GTK_CONTAINER( window ), 10 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 0, 1);
    gtk_table_attach_defaults( GTK_TABLE( table ), button, 0, 1, 1, 2);

    gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
                               (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT( window ));
    
    gtk_window_set_title( GTK_WINDOW( window ), "ERROR!" );
    gtk_container_add( GTK_CONTAINER( window ), table );
    gtk_widget_show( label );
    gtk_widget_show( button );
    gtk_widget_show( table );
    gtk_widget_show( window );
}

void succeed( void )
{
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *button;
    char scdstr[4096];
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    table = gtk_table_new( 1, 2, FALSE );
    sprintf( scdstr, "Operation succeeded :-)\nThe mangled file's name ist \"%s.mangled\"", gtk_entry_get_text( GTK_ENTRY( entry_file1 )));
    label = gtk_label_new( scdstr );
    button = gtk_button_new_with_label( "Close" );
    gtk_container_set_border_width( GTK_CONTAINER( window ), 10 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 1, 0, 1);
    gtk_table_attach_defaults( GTK_TABLE( table ), button, 0, 1, 1, 2);
    gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
                               (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT( window ));

    gtk_window_set_title( GTK_WINDOW( window ), "ERROR!" );
    gtk_container_add( GTK_CONTAINER( window ), table );
    gtk_widget_show( label );
    gtk_widget_show( table );
    gtk_widget_show( button );
    gtk_window_set_title( GTK_WINDOW( window ), "Succeded!" );
    gtk_widget_show( window );
}

int go( GtkWidget *widget,
        gpointer data )
{
    char r[3]="", c[3]="", n[3]="", x[3]="", d[3]="", w[3]="", l[3]="", e[1024]="", u[1024]="", o[3]="";
    char cmdline[4096];
    int status;
    if( GTK_TOGGLE_BUTTON(check_r)->active)  sprintf(r," -r");
    if( GTK_TOGGLE_BUTTON(check_c)->active)  sprintf(c," -c");
    if( GTK_TOGGLE_BUTTON(check_n)->active)  sprintf(n," -n");
    if( GTK_TOGGLE_BUTTON(check_x)->active)  sprintf(x," -x");
    if( GTK_TOGGLE_BUTTON(check_d)->active)  sprintf(d," -d");
    if( GTK_TOGGLE_BUTTON(check_w)->active)  sprintf(w," -w");
    if( GTK_TOGGLE_BUTTON(check_l)->active)  sprintf(l," -l");
    if( GTK_TOGGLE_BUTTON(check_o)->active)  sprintf(o," -o");
    if( GTK_TOGGLE_BUTTON(check_e)->active)  sprintf(e," -e \"%s\" %i", gtk_entry_get_text( GTK_ENTRY( entry_passwd)), gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( spinner_layers )));
    if( GTK_TOGGLE_BUTTON(check_u)->active)  sprintf(u," -u \"%s\" %i", gtk_entry_get_text( GTK_ENTRY( entry_passwd)), gtk_spin_button_get_value_as_int( GTK_SPIN_BUTTON( spinner_layers )));
    sprintf(cmdline,"mangle%s%s%s%s%s%s%s%s%s%s \"%s\"\n", r, c, n, x, n, w, l, o, e, u, gtk_entry_get_text( GTK_ENTRY( entry_file1 ) ) );
    status=system(cmdline);
    if(status==0)
    {
        succeed();
    }
    else
    {
        failed();
    }
}
    
            

int app_quit( GtkWidget *widget,
              gpointer data )
{
    gtk_main_quit();
}

main( int argc,
      char *argv[] )
{
    /* declare widget cariables */
    GtkWidget *window_main;
    GtkWidget *table;
    GtkWidget *label_file1;
    GtkWidget *label_passwd;
    GtkWidget *button_browse1;
    GtkWidget *button_cancel;
    GtkWidget *button_go;
    GtkWidget *separator1;
    GtkWidget *separator2;
    /* define widgets */
    gtk_init(&argc,&argv);
    g_print("Mangle (C) Jon Newman <jnewman@oplnk.net>\nXMangle by Rene van Bevern <RvB@pro-linux.de>\n");
    window_main = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    gtk_window_set_title( GTK_WINDOW( window_main ), __TITLE__ );
    gtk_container_set_border_width( GTK_CONTAINER( window_main ), 10 );
    table = gtk_table_new( 3, 11, FALSE );
    label_file1 = gtk_label_new( "Input file: ");
    entry_file1 = gtk_entry_new();
    button_browse1 = gtk_button_new_with_label( "Browse..." );
    label_passwd = gtk_label_new( "Password&Layers (encryption): " );
    entry_passwd = gtk_entry_new();
    separator1 = gtk_hseparator_new();
    separator2 = gtk_hseparator_new();
    check_r = gtk_check_button_new_with_label("Don't remove CR/LF");
    check_c = gtk_check_button_new_with_label("Only remove comments");
    check_n = gtk_check_button_new_with_label("Append newline to source");
    check_x = gtk_check_button_new_with_label("Null out options");
    check_d = gtk_check_button_new_with_label("Keep spaces in preprocessor entries");
    check_w = gtk_check_button_new_with_label("Write over original");
    check_o = gtk_check_button_new_with_label("Output to stdout");
    check_l = gtk_check_button_new_with_label("Do no mangling");
    check_e = gtk_check_button_new_with_label("Encrypt output");
    check_u = gtk_check_button_new_with_label("Decrypt output");
    button_go = xpmbutton( window_main, __GOXPM__, "Mangle!");
    button_cancel = xpmbutton( window_main, __CANCELXPM__, "Quit");
    gtk_entry_set_visibility( GTK_ENTRY( entry_passwd ), FALSE );
    adj = (GtkAdjustment*) gtk_adjustment_new( 1, 1, 999, 1, 5, 0 );
    spinner_layers = gtk_spin_button_new( adj, 0.5, 0 );
    /* place widgets */
    gtk_container_add( GTK_CONTAINER( window_main ), table );
    gtk_table_attach_defaults( GTK_TABLE( table ), label_file1, 0, 1, 0, 1 );
    gtk_table_attach_defaults( GTK_TABLE( table ), entry_file1, 1, 2, 0, 1 );
    gtk_table_attach_defaults( GTK_TABLE( table ), button_browse1, 2, 3, 0, 1);
    gtk_table_attach_defaults( GTK_TABLE( table ), label_passwd, 0, 1, 2, 3);
    gtk_table_attach_defaults( GTK_TABLE( table ), entry_passwd, 1, 2, 2, 3);
    gtk_table_attach_defaults( GTK_TABLE( table ), spinner_layers, 2, 3, 2, 3);
    gtk_table_attach_defaults( GTK_TABLE( table ), separator1, 0, 3, 3, 4 );
    gtk_table_attach_defaults( GTK_TABLE( table ), separator2, 0, 3, 9, 10 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_r, 0, 1, 4, 5 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_c, 1, 2, 4, 5 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_x, 0, 1, 5, 6 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_n, 1, 2, 5, 6 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_d, 1, 2, 6, 7 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_w, 0, 1, 6, 7 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_o, 0, 1, 7, 8 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_l, 1, 2, 7, 8 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_e, 0, 1, 8, 9 );
    gtk_table_attach_defaults( GTK_TABLE( table ), check_u, 1, 2, 8, 9 );
    gtk_table_attach_defaults( GTK_TABLE( table ), button_go, 1, 2, 10, 11);
    gtk_table_attach_defaults( GTK_TABLE( table ), button_cancel, 0, 1, 10, 11);
    /* Signal Connections */
    gtk_signal_connect( GTK_OBJECT( window_main ), "delete_event",
                        GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_WIDGET( window_main ) );
    gtk_signal_connect( GTK_OBJECT( window_main ), "destroy",
                        GTK_SIGNAL_FUNC( app_quit ), NULL );
    gtk_signal_connect( GTK_OBJECT( button_cancel ), "clicked",
                        GTK_SIGNAL_FUNC( app_quit ), NULL );
    gtk_signal_connect( GTK_OBJECT( button_go ), "clicked",
                        GTK_SIGNAL_FUNC( go ), NULL );
    gtk_signal_connect( GTK_OBJECT( button_browse1 ), "clicked",
                        GTK_SIGNAL_FUNC( browse_infile ), NULL );
    /* showing widgets */
    gtk_widget_show( spinner_layers );
    gtk_widget_show( label_passwd );
    gtk_widget_show( entry_passwd );
    gtk_widget_show( button_go );
    gtk_widget_show( button_cancel );
    gtk_widget_show( check_e );
    gtk_widget_show( check_u );
    gtk_widget_show( check_l );
    gtk_widget_show( check_o );
    gtk_widget_show( check_w );
    gtk_widget_show( check_d );
    gtk_widget_show( check_x );
    gtk_widget_show( check_n );
    gtk_widget_show( check_c );
    gtk_widget_show( check_r );
    gtk_widget_show( separator2 );
    gtk_widget_show( separator1 );
    gtk_widget_show( button_browse1 );
    gtk_widget_show( entry_file1 );
    gtk_widget_show( label_file1 );
    gtk_widget_show( table );
    gtk_widget_show( window_main);
    gtk_main();
    return(0);
}