/*
 * signals.cc:
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "olympus.h"
#include "signals.h"

sigfunc_rt *signal_rt(int signo, sigfunc_rt *func)
{
    struct sigaction act, oact;

    act.sa_handler = func;
    sigemptyset(&act.sa_mask);
    sigaddset(&act.sa_mask, signo);
    act.sa_flags = 0;

#if defined(SA_INTERRUPT) || defined(SA_RESTART)
    if (signo == SIGALRM)
    {
#if defined(SA_INTERUPT)
        act.sa_flags |= SA_INTERRUPT;   /* SunOS 4.x */
#endif /* SA_INTERRUPT */
    } else {
#if defined(SA_RESTART)
        act.sa_flags |= SA_RESTART;     /* SVR4, 4.4BSD */
#endif /* SA_RESTART */
    }
#endif /* SA_INTERRUPT || SA_RESTART */

    if (sigaction(signo, &act, &oact) < 0)
        return ((sigfunc_rt *) SIG_ERR);
    return oact.sa_handler;
}

