/*
 * processmanager.cc: stores process information
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "processmanager.h"

//#define DEBUG_PROCESSMANAGER

// processManager executes a single process and provides for reading
// the standard output from that process.
processManager::processManager(const char* command, char** arglist)
{
    char **arg;
    int fdlist[2];
    int idx;
    int length;

    pipe(fdlist);               //Make stdout and stderr the same stream.
    processID = fork();
    switch (processID)
    {
    case -1:
        // fork failed.
        throw processManagerFailedFork();
        break;

    case 0:
        // child.  Make the new process.
        close(fdlist[0]);       // we're not going to read from the pipe
        close(1);
        close(2);
        dup(fdlist[1]);
        dup(fdlist[1]);
        execv(command, arglist);
        throw processManagerFailedExec();
        break;

    default:
        // parent.  Store the vitals and return.
        close(fdlist[1]);       // the parent never writes to the pipe.
        fileDescriptor = fdlist[0];// we read from it
#if defined(DEBUG_PROCESSMANAGER)
        cerr << "processManager::processManager: fileDescriptor="
             << fileDescriptor << endl;
#endif
    }
}

processManager::~processManager(void)
{
    waitpid(processID, &processStatus, 0);
}

int processManager::getfd(void)
{
    return (fileDescriptor);
}

// read from the pipe.  should block when nothing is there but process
// is not dead.  return the number of bytes read.
int processManager::read(void *buffer, const int size)
{
    int count;

    count = ::read(fileDescriptor, buffer, size);
    return (count);
}

// write to the pipe
int processManager::write(void *buffer, int size)
{
    int count = 0;

    count = ::write(fileDescriptor, buffer, size);
    return (count);
}
