/*
 * pipemanager.cc: a simple class to keep track of open pipes
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "olympus.h"
#include "pipemanager.h"

pipeManager::pipeManager(processManager *processInfo)
{
    elements = new pipeElement(processInfo);
}

pipeManager::pipeElement::pipeElement(processManager *processInfo, pipeElement *next = NULL)
{
    process = processInfo;
    queued = false;
    nextElement = next;
}

pipeManager::pipeElement::~pipeElement(void)
{
    if (process != NULL)
    {
        delete process;
    }
}

pipeManager::~pipeManager(void)
{
    pipeElement *tmp, *next;

    for (tmp = elements; tmp; tmp = next)
    {
        next = tmp->nextElement;
        delete tmp;
    }
}

void pipeManager::add(processManager *processInfo)
{
    pipeElement *tmp(elements), *last(NULL);

    while (tmp != NULL)
    {
        if (processInfo->getfd() > tmp->getfd())
        {
            break;
        }
        last = tmp;
        tmp = tmp->nextElement;
    }

    if (last == NULL)
    {
        tmp = new pipeElement(processInfo, tmp);
        elements = tmp;
    }
    else last->nextElement = new pipeElement(processInfo, tmp);
}

void pipeManager::remove(int fd)
{
    pipeElement *tmp(elements), *last(NULL);

    while (tmp != NULL)
    {
        if (tmp->getfd() == fd)
        {
            if (last)
            {
                last->nextElement = tmp->nextElement;
            }
            else
            {
                elements = tmp->nextElement;
            }
            delete tmp;
            break;
        }
        last = tmp;
        tmp = tmp->nextElement;
    }
}

int pipeManager::pipeElement::getfd(void)
{
    return process->getfd();
}
