/*
 * nmVersion.cc
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "version.h"
#include "nmVersion.h"

nmVersion::nmVersion(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    members->add(&version_s, nmMemberList::intType, SIZEOF_INT);
    members->add(&version_p, nmMemberList::intType, SIZEOF_INT);
}

nmVersion::~nmVersion(void)
{
}

int nmVersion::activate(void)
{
    if (version_s > 0 && version_p > 0)
    {
        send(socket, PROTOCOL_VERSION);

        return 1;
    }
    return -1;
}

void nmVersion::prepareToSend(void)
{
    version_s = OLYMPUS_INTERNAL_VERSION;
    version_p = OLYMPUS_PROTOCOL_VERSION;
}
