#include "sequence.h"
#include "olympus.h"
#include "usermanager.h"
#include "nmStrStream.h"
#include "nmUsers.h"

nmUsers::nmUsers(transport *connection, unsigned long sessionID, unsigned long commandID)
  : netmessage(connection, sessionID, commandID)
{
    members->add(&username, nmMemberList::charstarType, 0);
    members->add(&password, nmMemberList::charstarType, 0);
    members->add(&action, nmMemberList::intType, 0);
}

nmUsers::~nmUsers(void)
{
    char *tmp;
    int i;

    if (username != NULL && action != NMUSERS_USER_ADDED)
    {
        for (i = 0, tmp = username; i < strlen(username); i++)
            *(tmp++) = '\0';
        delete username;
    }

    if (password != NULL)
    {
        for (i = 0, tmp = password; i < strlen(password); i++)
            *(tmp++) = '\0';
        delete password;
    }
}

int nmUsers::activate(void)
{
    /* determine what to do from the action id */
    if (action == NMUSERS_ADD_USER)
    {
        if (sysUsers->getPasswd(username) == NULL)
        {
            sysUsers->userAdd(username, password);
            action = NMUSERS_USER_ADDED;
            send(socket, NETMESSAGE);
            return 1;
        }
        else
        {
            action = NMUSERS_USER_EXISTS;
            send(socket, NETMESSAGE);
            return -1;
        }
    }
    else if (action == NMUSERS_REMOVE_USER)
    {
        sysUsers->userRemove(username);
        action = NMUSERS_USER_REMOVED;
        send(socket, NETMESSAGE);
        return 1;
    }
    else if (action == NMUSERS_CHANGE_PASSWORD)
    {
        sysUsers->changePasswd(username, password);
        sendHeader(socket, NETMESSAGE, COMMAND_SUCCESS);
        return 1;
    }
    else if (action == NMUSERS_LIST_ALL)
    {
        nmStrStream* message;
        vector<char *>* allUsers;
        char* nextString;
        int i, index, numUsers;
        
        index = 0;
        allUsers = sysUsers->userList();
        numUsers = allUsers->size();

        message = new nmStrStream(socket, sessionID, COMMAND_STRSTREAM, serverSequence.next());
        
        while (index < numUsers)
        {    
            for (i = 0; (i < StrStreamCapacity) && (index < numUsers); i++, index++)
            {
                nextString = (*allUsers)[index];

                if (nextString != NULL)
                {
                    message->addStr(nextString);
                }
                else i--;
            }
            message->send(socket, NETMESSAGE);
            message->clear();
        }
        
        if (numUsers % 10 == 0) { message->send(socket, NETMESSAGE); }
        
        delete allUsers;
        delete message;
        return 1;
    }
}

void nmUsers::prepareToSend(void)
{
    nmMemberList * currMember;

    currMember = members->nextMember;
    currMember->length = strlen(username);

    currMember = currMember->nextMember;
    currMember->length = strlen(password);

    currMember = currMember->nextMember;
    currMember->length = SIZEOF_INT;
}
