/*
 * nmUserAuth.cc: a netmessage object for user authenticaton.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "nmUserAuth.h"
#include "olympus.h"
#include "usermanager.h"
#include "cipher.h"
#include "sha.h"
#include "msgs.h"

nmUserAuth::nmUserAuth(transport *connection, unsigned long sessionID, unsigned long commandID)
  : netmessage(connection, sessionID, commandID)
{
    username = NULL;
    password = NULL;
    members->add(&username, nmMemberList::charstarType, 0);
    members->add(&password, nmMemberList::charstarType, 0);
}

nmUserAuth::~nmUserAuth(void)
{
    char *tmp;
    int i;

    if (username != NULL)
    {
        for (i = 0, tmp = username; i < strlen(username); i++)
            *(tmp++) = '\0';
        delete username;
    }

    if (password != NULL)
    {
        for (i = 0, tmp = password; i < strlen(password); i++)
            *(tmp++) = '\0';
        delete password;
    }
}

int nmUserAuth::activate(void)
{
    /* add this user if there is none in the database */
    if (sysUsers->hasEntries() == false)
    {
        sysUsers->userAdd(username, password);
        sendHeader(socket, USERAUTH_SUCCESS);
        return 1;
    }
    else
    {
        if (checkUserPass() == 0)
        {
            sendHeader(socket, USERAUTH_FAILURE);
            return -1;
        }
        else
        {
            sendHeader(socket, USERAUTH_SUCCESS);
            return 1;
        }
    }
}

void nmUserAuth::prepareToSend(void)
{
    nmMemberList * currMember;
    
    currMember = members->nextMember;
    currMember->length = strlen(username);
    
    currMember = currMember->nextMember;
    currMember->length = strlen(password);
}

int nmUserAuth::checkUserPass(void)
{
    unsigned char digest[SHA_DIGEST_SIZE];
    char* userpass, *hashpass;
    cipher tmpcipher;
    SHA hashfunc;
    int retc(0);

    hashfunc.hash((unsigned char *) password, digest, strlen(password));
    hashpass = tmpcipher.b10to16(digest, sizeof(digest));
    
    if ((userpass = sysUsers->getPasswd(username)) != NULL)
    {
        if (strcmp(userpass, hashpass) == 0)
        {
            retc = 1;
        }
        delete userpass;
    }
    delete hashpass;

    return retc;
}
