#include "exceptions.h"
#include "manager.h"
#include "sysbackup.h"
#include "nmUpdateConfig.h"

nmUpdateConfig::nmUpdateConfig(transport * connection , unsigned long sessionID, unsigned long commandID)
  : netmessage(connection ,sessionID, commandID)
{
    netModule = NULL;
    netFile = NULL;

    members->add(&netModule, nmMemberList::charstarType, 0);
    members->add(&netFile, nmMemberList::charstarType, 0);
    members->add(&info, nmMemberList::fileType, 0);
}

int nmUpdateConfig::activate()
{
    char buffer[4096];
    char* configfile;
    int ofd, ifd, rlen;

    if ((configfile = sysManager->filename(netModule, netFile)))
    {
        if ((ifd = open(info, O_RDONLY)) < 1)
        {
            cerr << "ERROR: couldn't open temp file in nmUpdateConfig::activate" << endl;
            return -1;
        }
    
        /* back up the file first */
        try
        {
            backupManager->backup(sysManager, netModule, netFile, "");
        }
        catch (fileOpenError)
        {
            cerr << "Update Config: could not backup file, as we could not open the original!" << endl;
            return -1;
        }
        catch (fileCreateError)
        {
            cerr << "Update Config: could not backup file, as we could not open the temp file!" << endl;
            return -1;
        }
        
        if ((ofd = open(configfile, O_CREAT|O_WRONLY|O_TRUNC, 0664)) > 0)
        {            
            while ((rlen = read(ifd, buffer, 4096)) > 0)
            {
                write(ofd, buffer, rlen);
            }
        }
    
        close(ofd);
        close(ifd);
        unlink(info);
        delete configfile;
        return 1;
    }
    else
    {
        return -1;
    }
}


void nmUpdateConfig::prepareToSend()
{
    nmMemberList * currMember;

    currMember = members->nextMember;
    currMember->length = strlen(netModule);

    currMember = currMember->nextMember;
    currMember->length = strlen(netFile);

    currMember = currMember->nextMember;
    currMember->length = strlen(info);
}


nmUpdateConfig::~nmUpdateConfig(void)
{
    delete[] netModule;
    delete[] netFile;
    delete[] info;
}
