/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSysInfo.cc
 *
 * Gets various system information from the server.
 *********************************************************************/

#include "olympus.h"
#include "manager.h"
#include "nmSysInfo.h"

nmSysInfo::nmSysInfo(transport * connection,
                             unsigned long sessionID,
                             unsigned long commandID)
    : netmessage(connection,sessionID,commandID)
{
}


// and the destructor
nmSysInfo::~nmSysInfo(void)
{
 
}

void nmSysInfo::prepareToSend(void) {}

// activate the message

int nmSysInfo::activate()
{
    OSStatus system;
    
    system.readCpuInfo("cpu", &user, &sys, &nice, &idle);
    
    members->add(&user, nmMemberList::intType, SIZEOF_INT);
    members->add(&sys, nmMemberList::intType, SIZEOF_INT);
    members->add(&nice, nmMemberList::intType, SIZEOF_INT);
    members->add(&idle, nmMemberList::intType, SIZEOF_INT);
    
    send(socket, NETMESSAGE);
    return 0;
}
