/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmStrStream.cc
 *
 * Enables sending of long sequences of char* type strings to a client
 *********************************************************************/

#include "nmStrStream.h"

nmStrStream::nmStrStream(transport * connection, 
                    unsigned long sessionID, 
                    unsigned long commandID,
                    int sequenceID = 0)
    : netmessage(connection, sessionID, commandID)
{
    sequence = sequenceID;
    filled = 0;
    strings[0] = NULL;
    strings[1] = NULL;
    strings[2] = NULL;
    strings[3] = NULL;
    strings[4] = NULL;
    strings[5] = NULL;
    strings[6] = NULL;
    strings[7] = NULL;
    strings[8] = NULL;
    strings[9] = NULL;
}

nmStrStream::~nmStrStream() 
{
    for (int i = 0; i < StrStreamCapacity; i++) { if (strings[i] != NULL) { delete strings[i]; } }
}

int nmStrStream::activate()
{
    return 1;
}

void nmStrStream::prepareToSend()
{
    if (members->nextMember != NULL) { delete members->nextMember; }
    
    for (int i = 9; i > filled - 1; i--)
    {
        if (strings[i] != NULL) { delete strings[i]; }
        
        strings[i]  = new char[2];
        strncpy(strings[i], "a", 1);
    }
    
    members->add(&sequence, nmMemberList::intType, SIZEOF_INT);
    members->add(&filled, nmMemberList::intType, SIZEOF_INT);    
    
    members->add(&strings[0], nmMemberList::charstarType, strlen(strings[0]));
    members->add(&strings[1], nmMemberList::charstarType, strlen(strings[1]));
    members->add(&strings[2], nmMemberList::charstarType, strlen(strings[2]));
    members->add(&strings[3], nmMemberList::charstarType, strlen(strings[3]));
    members->add(&strings[4], nmMemberList::charstarType, strlen(strings[4]));
    members->add(&strings[5], nmMemberList::charstarType, strlen(strings[5]));
    members->add(&strings[6], nmMemberList::charstarType, strlen(strings[6]));
    members->add(&strings[7], nmMemberList::charstarType, strlen(strings[7]));
    members->add(&strings[8], nmMemberList::charstarType, strlen(strings[8]));
    members->add(&strings[9], nmMemberList::charstarType, strlen(strings[9]));
}

int nmStrStream::addStr(char* strToAdd)
{
    if (filled >= StrStreamCapacity) { return TooFull; }
    if (filled < 0) { filled = 0; }
    if (strings[filled] != NULL) { delete strings[filled]; }
    
    strings[filled]  = new char[strlen(strToAdd) + 1];
    strncpy(strings[filled], strToAdd, strlen(strToAdd) + 1);
    
    return filled++;
}

int nmStrStream::fillStrs(char* str1, char* str2 = "", char* str3 = "", char* str4 = "", 
            char* str5 = "", char* str6 = "", char* str7 = "", 
            char* str8 = "", char* str9 = "", char* str10 = "")
{
    if (strncmp(str10, "", 1) == 0) { filled = 10; }
    else if (strncmp(str9, "", 1) == 0) { filled = 9; }
    else if (strncmp(str8, "", 1) == 0) { filled = 8; }
    else if (strncmp(str7, "", 1) == 0) { filled = 7; }
    else if (strncmp(str6, "", 1) == 0) { filled = 6; }
    else if (strncmp(str5, "", 1) == 0) { filled = 5; }
    else if (strncmp(str4, "", 1) == 0) { filled = 4; }
    else if (strncmp(str3, "", 1) == 0) { filled = 3; }
    else if (strncmp(str2, "", 1) == 0) { filled = 2; }
    else { filled = 1; }
    
    if (strings[0] != NULL) { delete strings[0]; }
    strings[0]  = new char[strlen(str1) + 1];
    strncpy(strings[0], str1, strlen(str1) + 1);

    if (strings[1] != NULL) { delete strings[1]; }
    strings[1]  = new char[strlen(str2) + 1];
    strncpy(strings[1], str2, strlen(str2) + 1);
    
    if (strings[2] != NULL) { delete strings[2]; }
    strings[2]  = new char[strlen(str3) + 1];
    strncpy(strings[2], str3, strlen(str3) + 1);

    if (strings[3] != NULL) { delete strings[3]; }
    strings[3]  = new char[strlen(str4) + 1];
    strncpy(strings[3], str4, strlen(str4) + 1);

    if (strings[4] != NULL) { delete strings[4]; }
    strings[4]  = new char[strlen(str4) + 1];
    strncpy(strings[4], str5, strlen(str5) + 1);

    if (strings[5] != NULL) { delete strings[5]; }
    strings[5]  = new char[strlen(str5) + 1];
    strncpy(strings[5], str6, strlen(str6) + 1);

    if (strings[6] != NULL) { delete strings[6]; }
    strings[6]  = new char[strlen(str6) + 1];
    strncpy(strings[6], str7, strlen(str7) + 1);

    if (strings[7] != NULL) { delete strings[7]; }
    strings[7]  = new char[strlen(str7) + 1];
    strncpy(strings[7], str8, strlen(str8) + 1);

    if (strings[8] != NULL) { delete strings[8]; }
    strings[8]  = new char[strlen(str8) + 1];
    strncpy(strings[8], str9, strlen(str9) + 1);

    if (strings[9] != NULL) { delete strings[9]; }
    strings[9]  = new char[strlen(str9) + 1];
    strncpy(strings[9], str10, strlen(str10) + 1);

    return filled;
}

void nmStrStream::clear() 
{
    filled = 0;
    if (strings[0] != NULL) { delete strings[0]; strings[0] = NULL; }
    if (strings[1] != NULL) { delete strings[1]; strings[1] = NULL; }
    if (strings[2] != NULL) { delete strings[2]; strings[2] = NULL; }
    if (strings[3] != NULL) { delete strings[3]; strings[3] = NULL; }
    if (strings[4] != NULL) { delete strings[4]; strings[4] = NULL; }
    if (strings[5] != NULL) { delete strings[5]; strings[5] = NULL; }
    if (strings[6] != NULL) { delete strings[6]; strings[6] = NULL; }
    if (strings[7] != NULL) { delete strings[7]; strings[7] = NULL; }
    if (strings[8] != NULL) { delete strings[8]; strings[8] = NULL; }
    if (strings[9] != NULL) { delete strings[9]; strings[9] = NULL; }
}
