/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSourceList.cc
 *
 * Receive a tarball from a client server and get status
 * on when it reaches the server.
 *****************************************************************/

#include <vector>
#include <string>
#include "olympus.h"
#include "packagemanager.h"
#include "nmStrStream.h"
#include "nmSourceList.h"

#define DEBUG_NMSOURCELIST

nmSourceList::nmSourceList(transport *sock, unsigned long sessID, unsigned long commID)
    : netmessage(sock, sessID, commID)
{
#if defined(DEBUG_NMSOURCELIST)
    cerr << "nmSourceList::nmSourceList: constructor" << endl;
#endif
    status = 0;
    members->add(&status, nmMemberList::intType, SIZEOF_INT);
}

nmSourceList::~nmSourceList()
{
}

// look up the package names.  Send names to client in packets of 10.
int nmSourceList::activate()
{
    nmStrStream* strstream;
    vector<char*>* software;
    int count;
    int index;
    int maxstrings;
    int retc = 1;

#if defined(DEBUG_NMSOURCELIST)
    cerr << "nmSourceList::activate: entry" << endl;
#endif

    software = sysPackages->getSoftware();

    if (software)
    {
        maxstrings = software->size();
    }
    else
    {
        maxstrings = 0;
    }
#if defined(DEBUG_NMSOURCELIST)
    cerr << "nmSourceList::activate: maxstrings=" << maxstrings << endl;
#endif
    index = 0;                  // contains the number currently sent

    while (index < maxstrings)
    {
        // send sendsize at a time
        strstream = new nmStrStream(socket, sessionID, commandID);
#if defined(DEBUG_NMSOURCELIST)
        cerr << "nmSourceList::activate: new nmStrStream" << endl;
#endif
        count = 0;
        while (count < StrStreamCapacity && index < maxstrings)
        {
#if defined(DEBUG_NMSOURCELIST)
            cerr << "nmSourceList::activate: addStr("
                 << (*software)[index] << ")" << endl;
#endif
            strstream->addStr((*software)[index]);
            count++;
        }
        ((netmessage*) strstream)->send(socket, sessionID);
        delete strstream;
    }

#if defined(DEBUG_NMSOURCELIST)
    cerr << "nmSourceList::activate: leaving" << endl;
#endif
    return retc;
}

// queue the stuff to send back
void nmSourceList::prepareToSend()
{
    nmMemberList* currMember = members->nextMember;

    currMember->length = SIZEOF_INT;
}
