/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSourceBuild.h
 *
 * Receive the package name from a client and use that to locate a
 * package to build.
 *
 *****************************************************************/

// c standard headers
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>

// c++ headers
#include <string>

// olympus headers
#include "olympus.h"
#include "manager.h"
#include "packagemanager.h"
#include "processmanager.h"
#include "nmSourceConfig.h"
#include "nmSourceBuild.h"

#define DEBUG_SOURCECONFIG

// constructor
nmSourceConfig::nmSourceConfig(transport* connection, unsigned long sessID, unsigned long commID)
    : nmProcess(connection, sessID, commID)
{
    filename = options = pkgname = streamFile = 0;
    processStatus = seconds = useconds = 0;

    members->add(&pkgname, nmMemberList::charstarType, 0);
    members->add(&options, nmMemberList::charstarType, 0);
}

// destructor
nmSourceConfig::~nmSourceConfig()
{
    delete[] filename;
    delete[] pkgname;
    delete[] options;
    delete[] streamFile;
}

// activate before there is a process
int nmSourceConfig::activate()
{
    return (1);
}

// activate on return from the process
int nmSourceConfig::activate(processManager* pm)
{
    int msglength;

#if defined(DEBUG_SOURCECONFIG)
    cerr << "nmSourceConfig::activate(processManager* pm) entry" << endl;
#endif
    // get the status from the pipe
    pm->read((char*) &seconds, sizeof(int));
    pm->read((char*) &useconds, sizeof(int));
    pm->read((char*) &processStatus, sizeof(int));
    pm->read((char*) &msglength, sizeof(int));

    // get the stream file name
    streamFile = new char[msglength];
    pm->read(streamFile, msglength);

    return 1;
}

// create the new process and hand it over to the server
processManager* nmSourceConfig::newProcess()
{
    processManager* pm = 0;
    char** arglist;
    char* command;
    char* ptr;
    int length;

    length = tmpDataPath->length() + strlen(pkgname) + 16;
    command = new char[length];
    tmpDataPath->copy(command, length);
    ptr = command + tmpDataPath->length();
    strcpy(ptr, "tmp/");
    ptr += 4;
    strcpy(ptr, pkgname);
    ptr += strlen(pkgname);
    strcpy(ptr, "/.configure");
    arglist = dissectString(options);
    pm = makeProcess(command, arglist);

    return (pm);
}

// get stuff ready to send back to the client
void nmSourceConfig::prepareToSend()
{
    struct stat st;

    delete members->nextMember;
    members->nextMember = NULL;

    // get the file size
    if (stat(streamFile, &st) != 0)
    {
        st.st_size = 0;
    }

    // send these
    members->add(&filename, nmMemberList::charstarType, strlen(filename));
    members->add(&pkgname, nmMemberList::charstarType, strlen(pkgname));
    members->add(&processStatus, nmMemberList::intType, sizeof(int));
    members->add(&seconds, nmMemberList::intType, sizeof(int));
    members->add(&useconds, nmMemberList::intType, sizeof(int));
    members->add(&streamFile, nmMemberList::fileType, st.st_size);
}
