/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSourceBuild.cc
 *
 * Receive the package name from a client and use that to locate a
 * package to build.
 *
 *****************************************************************/

// c++ headers
#include <string>

// olympus headers
#include "olympus.h"
#include "manager.h"
#include "packagemanager.h"
#include "nmSourceBuild.h"
#include "processmanager.h"

#define DEBUG_SOURCEBUILD

// constructor
nmSourceBuild::nmSourceBuild(transport* socket, unsigned int sessionID, unsigned int commandID)
    : nmProcess(socket, sessionID, commandID)
{
    file = pkgname = tmpFilePath = 0;
    processStatus = seconds = useconds = 0;

    delete members->nextMember;
    members->nextMember = NULL;
    members->add(&pkgname, nmMemberList::charstarType, 0);
    members->add(&options, nmMemberList::charstarType, 0);
}

// destructor
nmSourceBuild::~nmSourceBuild()
{
    delete file;
    delete pkgname;
    delete tmpFilePath;
}

// nothing happens here; look in newProcess()
int nmSourceBuild::activate()
{
    return 1;
}

// get the return data
int nmSourceBuild::activate(processManager* pm)
{
    int msglength;

    // get the data from the pipe
    pm->read((char *) &seconds, sizeof(int));
    pm->read((char *) &useconds, sizeof(int));
    pm->read((char *) &processStatus, sizeof(int));
    pm->read((char *) &msglength, sizeof(int));

    // get the name of the data file returned.
    tmpFilePath = new char[msglength + 1];
    pm->read(tmpDataPath, msglength); // msglength includes the null

    return (1);
}

// return the process to the server
processManager* nmSourceBuild::newProcess()
{
    processManager* pm = 0;
    string command;
    char* buildpath;
    char* execpath;
    char* arg[2];
    char* ptr;
    int length;
    int tmp0;
    int tmp1;

#if defined(DEBUG_SOURCEBUILD)
    cerr << "nmSourceBuild::newProcess() entering..." << endl;
#endif
    // construct the build path; the path where execution calls cwd
    length = tmpDataPath->length() + strlen(pkgname) + 5;
    buildpath = ptr = new char[length];
    tmpDataPath->copy(buildpath, length);
    ptr += tmpDataPath->length();
    strcpy(ptr, "tmp/");
    ptr += 4;
    strcpy(ptr, pkgname);

    // construct the execution path; PATH has this first on execution
    length = baseOlympusPath->length() + 4;
    execpath = ptr = new char[length];
    baseOlympusPath->copy(execpath, length);
    ptr += baseOlympusPath->length();
    strcpy(ptr, "bin");

    // for now assume that we are just going to call make.  All that's needed
    // is arg[0] = "make" and arg[1] = '\0'.
    // get the absolute path to the make command
    pm = makeProcess("sourcemake", "make", 0);
    if (ptr)
    {
        command = ptr;
        // make the arguments for olyexec
        tmp0 = command.rfind("/") + 1;       // the main command "make"
        tmp1 = command.substr(tmp0).length() + 1;
        arg[0] = new char[tmp1];
        command.copy(arg[0], tmp1, tmp0);
        arg[1] = 0;
        try
        {
#if defined(DEBUG_SOURCEBUILD)
            cerr << "nmSourceBuild::newProcess() new process" << endl;
#endif
            pm = new processManager(command.c_str(), arg);
        }
        catch (...)
        {
#if defined(DEBUG_SOURCEBUILD)
            cerr << "nmSourceBuild::newProcess() null process" << endl;
#endif
            pm = NULL;
        }
    }

    return (pm);
}

// send the data to the client
void nmSourceBuild::prepareToSend()
{
    struct stat sbuf;
    int size;

    delete members->nextMember;
    members->nextMember = NULL;

    if (stat(tmpFilePath, &sbuf) == 0)
    {
        size = sbuf.st_size;
    }
    else
    {
        size = 0;
    }

    // add the members to transmitt
    members->add(&file, nmMemberList::charstarType, strlen(file) + 1);
    members->add(&pkgname, nmMemberList::charstarType, strlen(pkgname) + 1);
    members->add(&processStatus, nmMemberList::intType, 0);
    members->add(&seconds, nmMemberList::intType, 0);
    members->add(&useconds, nmMemberList::intType, 0);
    members->add(&tmpFilePath, nmMemberList::fileType, size);
}
