#include "manager.h"
#include "olympus.h"
#include "nmSetExec.h"

nmSetExecute::nmSetExecute(transport *connection, unsigned long sessionID, unsigned long commandID)
  : netmessage(connection, sessionID, commandID)
{
    members->add(&netModule, nmMemberList::charstarType, 0);
    members->add(&netAction, nmMemberList::charstarType, 0);
    members->add(&netCommand, nmMemberList::charstarType, 0);
}

nmSetExecute::~nmSetExecute()
{
    delete netModule;
    delete netAction;
    delete netCommand;
}

int nmSetExecute::activate()
{
    sysManager->addValue(netModule, netAction, netCommand);

    return 1;
}


void nmSetExecute::prepareToSend()
{
    nmMemberList * currMember;
    
    currMember = members->nextMember;
    currMember->length = strlen(netModule);
    
    currMember = currMember->nextMember;
    currMember->length = strlen(netAction);
    
    currMember = currMember->nextMember;
    currMember->length = strlen(netCommand);
}
