/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmProcess.c
 *
 * Subclassed from netmessage provide all the function necessary
 * for a netmessage that handles a processManager* stream
 *
 *****************************************************************/

// c standard headers
#include <stdarg.h>
#include <string.h>

// c++ headers
#include <string>

// olympus headers
#include "config.h"
#include "defs.h"
#include "olympus.h"
#include "manager.h"
#include "processmanager.h"
#include "nmProcess.h"

#define DEBUG_NMPROCESS

nmProcess::nmProcess(transport* connection, unsigned long sessID, unsigned long commID)
    : netmessage(connection, sessID, commID)
{
    streamFile = 0;
    processStatus = seconds = useconds = 0;
}

nmProcess::~nmProcess()
{
    delete[] streamFile;
}

// count the number of words in the string
int nmProcess::countWords(char* text)
{
    char *ptr;
    bool wordflag;
    int count;

    // count the number of words in the string
    count = 0;
    ptr = text;
    while (ptr)
    {
        // gobble white space
        while (isspace(*ptr))
        {
            ptr++;
        }
        // gobble this word
        wordflag = false;
        while (! isspace(*ptr))
        {
            wordflag = true;
            ptr++;
        }
        if (wordflag)
        {
            count++;
        }
    }

    return (count);
}

// parse the string delimited by white space and return each token as an
// element in an array.
char** nmProcess::dissectString(char* argStr)
{
    char** arglist;
    char *ptr0;
    char* ptr1;
    int count;
    int size;

    count = countWords(argStr);
#if defined(DEBUG_NMPROCESS)
    cerr << "nmProcess::dissectString() counted "
         << count << " words." << endl;
#endif
    arglist = new char*[count + 1];
    count = 0;
    ptr0 = argStr;
    while (ptr0)
    {
        // gobble white space
        while (*ptr0 && isspace(*ptr0))
        {
            ptr0++;
        }
        // we're in a word now
        ptr1 = ptr0;
        while (*ptr0 && ! isspace(*ptr0))
        {
            ptr0++;
        }
        // allocate space and copy the word
        if (ptr1 < ptr0)
        {
            size = ptr0 - ptr1;
            arglist[count] = new char[size + 1];
            strncpy(arglist[count], ptr1, size);
            arglist[count++] = '\0';
        }
    }

    return (arglist);
}

// given an array of pointers constructed by dissectString delete the
// array elements and then the array.  the array must be terminated by a
// null element.
void nmProcess::deleteArray(char** arg)
{
    char **ptr;

#if defined(DEBUG_NMPROCESS)
    cerr << "nmProcess::dissectArray() not implemented" << endl;
#endif
    ptr = arg;
    while (*ptr)
    {
        delete[] *ptr;
        ptr++;
    }
    delete[] arg;
}

// return the ascii value for the numeric argument
char* nmProcess::intToString(int value, char *buffer)
{
    static char buff[32];
    char *ptr;
    bool sign;
    int digit;
    int remdr;

    buff[31] = '\0';
    ptr = buff + 30;
    if (value < 0)
    {
        remdr = -value;
        sign = true;
    }
    else
    {
        remdr = value;
        sign = false;
    }
    while (remdr)
    {
        digit = remdr % 10;
        *ptr-- = digit + '0';
        remdr /= 10;
    }
    if (sign)
    {
        *ptr = '-';
    }
    strcpy(buffer, ptr + 1);

    return (ptr);
}

// make standard args to call olyexec.  assume that args has already
// been allocated.
char* nmProcess::makeArgs(char** arglist, char** args)
{
    string text;
    char** aptr;
    char** argptr;
    char buffer[64];
    char* cmd;
    int length;
    int tmp;

    aptr = arglist;

    // get the absolute path to olyexec to return to the user
    text  = *baseOlympusPath + "olyexec";
    length = text.length() + 1;
    cmd = new char[length];
    text.copy(cmd, length);

    // get the file name as argv[0]
    tmp = text.rfind('/') + 1;
    length = text.substr(tmp).length() + 1;
    *aptr = new char[length];
    text.copy(*aptr, length, tmp);
    aptr++;

    // add sessionID as argv[1]
    intToString(sessionID, buffer);
    length = strlen(buffer) + 1;
    *aptr = new char[length];
    strcpy(*aptr, buffer);
    aptr++;

    // add commandID as argv[2]
    intToString(commandID, buffer);
    length = strlen(buffer) + 1;
    *aptr = new char[length];
    strcpy(*aptr, buffer);
    aptr++;

    // first path element as argv[3]
    text = *baseOlympusPath + "bin";
    length = text.length() + 1;
    *aptr = new char[length];
    text.copy(*aptr, length);
    aptr++;

    // work directory as argv[4]
    text = *tmpDataPath + "tmp";
    length = text.length() + 1;
    *aptr = new char[length];
    text.copy(*aptr, length);
    aptr++;

    // assuming that args is NULL terminated, copy the args to the new
    // array.
    argptr = args;
    while (*argptr)
    {
        *aptr++ = *argptr++;
    }
    *aptr = NULL;

    return (cmd);
}


// create a new process with the provided command line
processManager* nmProcess::makeProcess(const char* key1,
                                       const char* key2,
                                       char **args)
{
    processManager* pm = 0;
    char** arglist;
    char** aptr;
    char* arg0;
    char* cmd;
    int count;

    cmd = sysManager->filename(key1, key2);
    if (cmd)
    {
        // count the size of args and use that to allocate a new array for
        // the whole argument list.
        count = 0;
        aptr = args;
        while (*aptr)
        {
            count++;
            aptr++;
        }
        count += 5;             // extra args
        arglist = new char*[count];
        arg0 = makeArgs(arglist, args);

        // create the new process
        try
        {
#if defined(DEBUG_NMPROCESS)
            aptr = arglist;
            cerr << "nmProcess::makeArgs(key1, key2, args) args are" << endl;
            while (*aptr)
            {
                cerr << "\t" << aptr++ << endl;
            }
#endif
            pm = new processManager(arg0, arglist);
        }
        catch (...)
        {
            return (0);
        }

        // clean up the heap
        for (count = 0; count < 5; count++)
        {
            delete[] arglist[count];
        }
        delete[] arglist;
    }

    return (pm);
}

// create a new process which looks up the actual process to call with
// the arguments as keys.
processManager* nmProcess::makeProcess(const char* key1, const char* key2, ...)
{
    processManager* pm = 0;
    string command;
    va_list ap;
    char** arglist;
    char* ptr;
    int count;
    int idx;
    int start;
    int size;

    ptr = sysManager->filename(key1, key2);
    if (ptr != NULL)
    {
        command = ptr;

        // count the arguments
        count = 0;
        va_start(ap, key2);
        while ((ptr = va_arg(ap, char*)) != NULL)
        {
            count++;
        }
        count += 2;             // argv[0] and NULL terminator plus arguments

        idx = 0;
        arglist = new char*[count];
        start = command.rfind("/") + 1;
        size = command.substr(start).length() + 1;
        arglist[idx] = new char[size];
        command.copy(arglist[idx++], size, start);

        // pass down the arguments putting them in the list
        va_start(ap, key2);
        while ((ptr = va_arg(ap, char*)) != NULL)
        {
            size = strlen(ptr) + 1;
            arglist[idx] = new char[size];
            strncpy(arglist[idx], ptr, size);
            arglist[idx++] = '\0';
        }
        arglist[idx] = '\0';    // terminate the list

        // create the process
        try
        {
            pm = new processManager(command.c_str(), arglist);
        }
        catch (...)
        {
            return (0);
        }
        this->deleteArray(arglist);
    }

    return (pm);
}

// create a new process from a path and a list of the arguments.  path
// should be an absolute path to the executable.
processManager* nmProcess::makeProcess(char* path, char **args)
{
    processManager* pm = 0;
    string command = path;
    char** arglist;
    char** aptr;
    char* ptr;
    int count;
    int length;

    // count the number of arguments
    count = 0;
    aptr = args;
    while (*aptr)
    {
        count++;
        aptr++;
    }
    count += 2;                 // command + # args + NULL

    arglist = new char*[count]; // create new arglist

    if ((ptr = strrchr(path, '/')) != NULL)
    {
        ptr++;
    }
    else
    {
        ptr = path;
    }

    // make arglist[0]
    length = strlen(ptr) + 1;
    arglist[0] = new char[length];
    strcpy(arglist[0], ptr);

    // copy the rest of the arguments
    for (count = 0; args[count]; count++)
    {
        arglist[count + 1] = args[count];
    }

    // create the process
    try
    {
        pm = new processManager(path, arglist);
    }
    catch (...)
    {
        return (0);
    }

    return (pm);
}

// helper to make array of args for olyexec
