/*
 * nmPing.cc: used to ping a host's olympus server.
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include <sys/time.h>
#include <unistd.h>
#include "nmPing.h"
#include "msgs.h"

nmPing::nmPing(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection,sessionID,commandID)
{
    members->add(&seconds,nmMemberList::longType, SIZEOF_LONG);
    members->add(&usecs,nmMemberList::longType, SIZEOF_LONG);
}


nmPing::nmPing(transport* connection, unsigned long sessionID, unsigned long commandID, long int secs, long int musecs)
    : netmessage(connection,sessionID,commandID)
{
    seconds = secs,
    usecs = musecs;
    members->add(&seconds,nmMemberList::longType, SIZEOF_LONG);
    members->add(&usecs,nmMemberList::longType, SIZEOF_LONG);
}

nmPing::~nmPing(void)
{
}

int nmPing::activate(void)
{
    send(socket, NETMESSAGE);
    return 1;
}

void nmPing::prepareToSend(void)
{
}
