/*
 * nmKexReply.cc
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "cipher.h"
#include "bn.h"
#include "nmKexReply.h"

nmKexReply::nmKexReply(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    members->add(&nbits_f, nmMemberList::intType, SIZEOF_INT);
    members->add(&f, nmMemberList::binaryType, 0);
}

nmKexReply::~nmKexReply(void)
{
    if (f != NULL)
    {
        delete f;
    }
}

int nmKexReply::activate(void)
{
    struct BigNum* final;

    if (nbits_f > 0)
    {
        final = new struct BigNum;
        bnBegin(final);
        bnInsertLittleBytes(final, f, 0, nbits_f >> 3);

        socket->kexGenerate(final);

        return 1;
    }
    return -1;
}

void nmKexReply::prepareToSend(void)
{
}
