/*
 * nmKexInit.cc: get primes for Diffie Hellman key exchange
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include "olympus.h"
#include "primepool.h"
#include "bn.h"
#include "nmKexInit.h"

nmKexInit::nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID)
    : netmessage(connection, sessionID, commandID)
{
    p = g = f = NULL;
    prime = generator = pubkey = NULL;
    members->add(&nbits_p, nmMemberList::intType, SIZEOF_INT);
}

nmKexInit::~nmKexInit(void)
{
    if (p != NULL)
    {
        primeSet->remove(p);
    }

    if (g != NULL)
    {
        bnEnd(g);
        delete g;
    }

#if 0 // no need to delete this, DH handles it
    if (f != NULL)
    {
        bnEnd(f);
        edlete f;
    }
#endif

    if (prime != NULL)
    {
        delete prime;
    }

    if (generator != NULL)
    {
        delete generator;
    }

    if (pubkey != NULL)
    {
        delete pubkey;
    }
}

int nmKexInit::activate(void)
{
    if (nbits_p <= 1024)
    {
        p = primeSet->getPrime(nbits_p);

        g = new struct BigNum;
        bnBegin(g);
        bnSetQ(g, 2);

        socket->kexInit(p, g);

        send(socket, KEX_DH_INIT);

        return 1;
    }
    return -1;
}

void nmKexInit::prepareToSend(void)
{
    int nbytes_p, nbytes_g, nbytes_f;

    f = socket->kexPublic();

    nbytes_p = bnBytes(p);
    nbytes_g = bnBytes(g);
    nbytes_f = bnBytes(f);
    nbits_p = nbytes_p << 3;
    nbits_g = nbytes_g << 3;
    nbits_f = nbytes_f << 3;

    prime = new unsigned char[nbytes_p];
    bnExtractLittleBytes(p, prime, 0, nbytes_p);
    members->add(&prime, nmMemberList::binaryType, nbytes_p);

    generator = new unsigned char[nbytes_g];
    bnExtractLittleBytes(g, generator, 0, nbytes_g);
    members->add(&nbits_g, nmMemberList::intType, SIZEOF_INT);
    members->add(&generator, nmMemberList::binaryType, nbytes_g);

    pubkey = new unsigned char[nbytes_f];
    bnExtractLittleBytes(f, pubkey, 0, nbytes_f);
    members->add(&nbits_f, nmMemberList::intType, SIZEOF_INT);
    members->add(&pubkey, nmMemberList::binaryType, nbytes_f);
}
