/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmFetchConfig.cc
 *
 * Sends a requested configuration file back to the connected client
 *********************************************************************/

#include <fstream>
#include "olympus.h"
#include "manager.h"
#include "nmFetchConfig.h"

// here's the constructor
nmFetchConfig::nmFetchConfig(transport * connection,
                             unsigned long sessionID,
                             unsigned long commandID)
    : netmessage(connection,sessionID,commandID)
{
    members->add(&module, nmMemberList::charstarType, 0);
    members->add(&file, nmMemberList::charstarType, 0);
    fileToSend = 0;
}


// and the destructor
nmFetchConfig::~nmFetchConfig(void)
{
    if (fileToSend)
    {
        delete[] fileToSend;
    }
}

void nmFetchConfig::prepareToSend(void)
{
}

int nmFetchConfig::activate()
{
    nmMemberList* currMember;
    struct stat st;
    char* filename;
    int fexist;

    currMember = members->nextMember;
    currMember->length = strlen(module);

    currMember = currMember->nextMember;
    currMember->length = strlen(file);

    if ((filename = sysManager->filename(module, file)))
    {
        fexist = stat(filename, &st);

        if (fexist == 0)
        {
            int flen(strlen(filename));

            fileToSend = new char[flen + 1];
            strncpy(fileToSend, filename, strlen(filename));
            fileToSend[flen] = '\0';
            members->add(&fileToSend, nmMemberList::fileType, st.st_size);
        }
        else
        {
            members->add(&fileToSend, nmMemberList::fileType, 0);
        }
    }
    else
    {
        members->add(&fileToSend, nmMemberList::fileType, 0);
    }

    send(socket, NETMESSAGE);

    return 1;
}
