#include "olympus.h"
#include "manager.h"
#include "nmExec.h"

nmExec::nmExec(transport *connection, unsigned long sessionID, unsigned long commandID)
  : netmessage(connection, sessionID, commandID)
{
    members->add(&netModule, nmMemberList::charstarType, 0);
    members->add(&netAction, nmMemberList::charstarType, 0);
}


int nmExec::activate(void)
{
    sysManager->execute(netModule, netAction);
 
    return 1;
}


void nmExec::prepareToSend(void)
{
    nmMemberList * currMember;
    
    currMember = members->nextMember;
    currMember->length = strlen(netModule);
    
    currMember = currMember->nextMember;
    currMember->length = strlen(netAction);
}


nmExec::~nmExec(void)
{
    delete netModule;
    delete netAction;
}
