#ifndef __nmStrStream_h_
#define __nmStrStream_h_

#include "netmessage.h"

#define TooFull 0
#define Successful 1
#define StrStreamCapacity 10

class nmStrStream: public netmessage
{
    public:
        nmStrStream(transport * connection, 
                    unsigned long sessionID, 
                    unsigned long commandID,
                    int sequenceID = 0);
        ~nmStrStream();
        
        /* standard netmessage virtual classes */
        virtual int activate();
        virtual void prepareToSend();
    
        /* if you can't figure this one out =) */
        int addStr(char* strToAdd);
        
        /* this will place the values given it into the the strings
           it does NOT preserve previous values (actually, it kills them) */
        int fillStrs(char* str1, char* str2 = "", char* str3 = "", char* str4 = "", 
                    char* str5 = "", char* str6 = "", char* str7 = "", 
                    char* str8 = "", char* str9 = "", char* str10 = "");
        
        /* removes all strings and sets them to empty strings */
        void clear();
        
        /* these functions can be used to get the current "fullness" */
        int amtFilled() { return filled; }
        int amtEmpty()  { return StrStreamCapacity - filled; }
        
        /* use this to set and get the sequence number, which is used
           on the client side to know that a netmessage belongs to a specific
           stream */
        void setSequence(int sequenceID) { sequence = sequenceID; }
        int getSequence() { return sequence; }
        
        
    private:
        int sequence, filled;
        char* strings[StrStreamCapacity];
};

#endif