/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSourceExpand.h
 *
 * Receive a tarball from a client server and get status
 * on when it reaches the server.
 *****************************************************************/

#ifndef __nmSourceExpand_h_
#define __nmSourceExpand_h_

/* external classes */
class processManager;

#include <vector>
#include "nmProcess.h"

class nmSourceExpand : public nmProcess
{
  public:
    nmSourceExpand(transport *connection, unsigned long int sessionID, unsigned long int netmessageID);
    ~nmSourceExpand();
    void prepareToSend();
    int activate();             // expand it and send back the status
    int activate(processManager *pm); // called with the process
    processManager *newProcess();

  private:
    char *filename;             // name for tarball
    char *tarname;              // name for the build directory
    char *tmpFilePath;          // path to temporary file
    int processStatus;          // status from olyexec
    int numberOfFiles;          // number of files expanded
    int seconds;                // seconds of elapsed time
    int useconds;               // micro seconds of elapsed time

    // the default constructor is hidden (and not implemented)
    nmSourceExpand();

    // copy the tempfile to a real file.
    int copyfile(string *tarpath);

    // expand the tarfile and associated
    processManager* untarfile();
    vector<string>* getExtension(const string *filename);
    void sendDocFiles(string& path);
    char **makearglist(vector<string>* args);
};

#endif // __nmSourceExpand_h_
