/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmSourceBuild.h
 *
 * Receive the package name from a client and use that to locate a
 * package to build.
 *
 *****************************************************************/

#ifndef __nmSourceConfig_h_
#define __nmSourceConfig_h_

#include "nmProcess.h"

class processManager;

class nmSourceConfig : public nmProcess
{
public:
    nmSourceConfig(transport* connection, unsigned long sessID, unsigned long commID);
    ~nmSourceConfig();

    // reimplemented from netmessage
    int activate();
    int activate(processManager* pm);
    void prepareToSend();

    // access to a new process
    processManager* newProcess();

private:
    nmSourceConfig();           // unused

    // private method
    char** dissectOptions(char* optionstr);

    // private data
    char* filename;             // actual tar file name
    char* pkgname;              // user's name for the package
    char* options;              // options to give to configure
    char* streamFile;           // path of file for process output
    int processStatus;          // status from the process
    int seconds;                // elapsed time in seconds
    int useconds;               // elapsed time in addition to the seconds
};

#endif
