/*****************************************************************
 *
 * Copyright (c) 2000 Mount Linux Inc.
 *
 * nmProcess.h
 *
 * Subclassed from netmessage provide all the function necessary
 * for a netmessage that handles a processManager* stream
 *
 *****************************************************************/

#ifndef __nmProcess_h_
#define __nmProcess_h_

#include "netmessage.h"

class processManager;

class nmProcess : public netmessage
{
public:    
    nmProcess(transport* connection, unsigned long sessID, unsigned long commandID);
    ~nmProcess();

protected:
    char* streamFile;           // return data from the process i/o
    int processStatus;          // return code from the process
    int seconds;                // runtime in seconds
    int useconds;               // remainder in microseconds

    // methods
    char** dissectString(char* argStr);
    void deleteArray(char** arg);
    char* intToString(int value, char* buffer);
    char* makeArgs(char** arglist, char** args);

    processManager* makeProcess(const char* key1, const char* key2, ...);
    processManager* makeProcess(const char*, const char*, char**);
    processManager* makeProcess(char* command, char** args);

private:
    int countWords(char* text);
};

#endif
