/*
 * nmKexInit.h: get primes for Diffie Hellman key exchange
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __nmKexInit_h_
#define __nmKexInit_h_

#include "netmessage.h"

class nmKexInit: public netmessage
{
    public:
        nmKexInit(transport* connection, unsigned long sessionID, unsigned long commandID);
        ~nmKexInit(void);

        virtual int activate(void);
        virtual void prepareToSend(void);

    private:
        unsigned char* prime;
        unsigned char* generator;
        unsigned char* pubkey;
        struct BigNum* p;
        struct BigNum* g;
        struct BigNum* f;
        int nbits_p;
        int nbits_g;
        int nbits_f;
};

#endif /* __nmKexInit_h_ */
