/*
 *  This code was writen by Chris Schlaeger for ktop
 *  Sebastien Taylor made a few minor changes to get
 *  it working as a netmessage in Olympus.
 */

#ifndef _OSStatus_h_
#define _OSStatus_h_

#include <stdio.h>
#include <string>

#ifdef __osf__
#include <sys/table.h>
#endif

#ifdef __sun__
#include <kstat.h>
#include <sys/sysinfo.h>
#endif

#define PROC_FILEOPENERROR 100
#define PROC_READERROR 101
#define MEMINFO_READERROR 200
/**
 * This class implements an abstract interface to certain system parameters
 * like the system load or the memory usage. The information can be retrieved
 * with member functions of this class.
 */
class OSStatus
{
public:
	OSStatus();

	~OSStatus();

	/**
	 * If an error has occured the return value of this function will be
	 * false, true otherwise.
	 */
	bool ok(void) const
	{
		return (!error);
	}

	/**
	 * If an error has occured the functions return an error message. If no
	 * error has occured it returns an empty string.
	 */
	int getErrMessage(void) const
	{
		return (errMessage);
	}

	/**
	 * This function calculates the overall system load. The load is split into
	 * user, system, nice and idle load. The values are in percent (0 - 100).
	 * If an error occured the return value is false, otherwise true.
	 */
	bool getCpuLoad(int& user, int& sys, int& nice, int& idle);

	/**
	 * This function returns the number of CPUs installed. It must be called
	 * before the first call to getCpuXLoad!
	 */
	int getCpuCount(void);

	/**
	 * This function calculates the load for CPU 'cpu'. The load is split into
	 * user, system, nice and idle load. The values are in percent (0 - 100).
	 * If an error occured the return value is false, otherwise true.
	 */
	bool getCpuXLoad(int cpu, int& user, int& sys, int& nice, int& idle);

	/**
	 * This function determines the memory usage of the system. All values
	 * are for physical memory only. If an error occured the return value is
	 * false, otherwise true. All values are in kBytes.
	 */
	bool getMemoryInfo(int& mtotal, int& mfree, int& used, int& buffers,
					   int& cached);

	/**
	 * This function deterines the total swap space size and the used swap
	 * space size. If an error occured the return value is false, otherwise
	 * true. All values are in kBytes.
	 */
	bool getSwapInfo(int& stotal, int& sfree);

	/**
	 * This functions returns the number of processes that are currently
	 * running on the system.
	 */
	int getNoProcesses(void);

	/**
	 * This function reads the information for the cpu 'cpu'. This can be
	 * "cpu" or "cpu0", "cpu1" etc. on SMP systems.
	 */
	bool readCpuInfo(const char* cpu, int* u, int* s, int* n, int* i);

private:
	/**
	 * The private functions are helper functions for the public functions.
	 * They need not to make sense on all platforms. If a platform cannot use
	 * a private functions it just needs to implement a dummy. Each platform
	 * may have it's own set of functions although some overlap would be
	 * desirable.
	 */

	/**
	 * The number of CPUs the system has.
	 */
	int cpuCount;

	/**
	 * To determine the system load we have to calculate the differences
	 * between the ticks values of two successive calls to getCpuLoad. These
	 * variables are used to store the ticks values for the next call.
	 */
	int userTicks;
	int sysTicks;
	int niceTicks;
	int idleTicks;

	/**
	 * And now the same again for SMP systems. The arrays are allocated when
	 * needed.
	 */
	int* userTicksX;
	int* sysTicksX;
	int* niceTicksX;
	int* idleTicksX;
#ifdef __osf__
	/// have a private tbl_sysinfo-pointer, that is new'ed once in 
	/// getCpuCount(). This seems much cleaner than having, newing 
	/// and deleting it in every call of getCpuXload().
struct tbl_sysinfo *si;
        /// But we don't need the following under OSF
#else
	/// This file pointer is used to access the /proc/stat file.
	FILE* stat;
#endif

#ifdef __sun__
	/// Access-Handle to the kstat-interface
	kstat_ctl_t   *kstat_control;

	/// factor block -> kByte
	long pagefactor;

	/// 
	vminfo_t swap_info;

	///
	hrtime_t ks_time;

	/// CPU-load
	unsigned long *cpu_info;
	int *last_user, *last_sys, *last_idle, *last_wait;

#endif

	/// These variables are used for the error handling.
	bool error;
	int errMessage;
} ;

#endif
