#include "exceptions.h"
#include "cipher.h"
#include "manager.h"
#include "sysbackup.h"

void sysBackup::backup(manager* manager, const char* module, const char* file, const char* info)
{
    char* configfile, *filedigest, *filestamp, *backupfile;
    unsigned char buffer[4096];
    string* fileinfo;
    ifstream* ifs;
    ofstream* ofs;
    int revision;
    time_t now;

    if ((configfile = manager->filename(module, file)))
    {
        cipher tmpcipher;

        if (!*(ifs = new ifstream(configfile, ios::in)))
        {
            cerr << "Unable to open file " << configfile << " for backup" << endl;
            throw fileOpenError(configfile);
        }

        /* file a suitable (available) filename for the backup file */
        now = time(NULL);
        revision = uniqueRevision(file, now);

        backupfile = backupName(file, now, revision);

        if (!*(ofs = new ofstream(backupfile, ios::out)))
        {
            cerr << "Unable to open backup file " << backupfile << endl;
            throw fileCreateError(backupfile);
        }

        while (!(ifs->eof()))
        {
            ifs->read(buffer, sizeof(buffer));
            ofs->write(buffer, ifs->gcount());
        }

        /* combine the time and the revision number to get the file stamp */
        memcpy(buffer, (void *) &now, sizeof(time_t));
        memcpy(buffer + sizeof(time_t), (void *) &revision, sizeof(int));

        filestamp = tmpcipher.b10to16(buffer, sizeof(time_t) + sizeof(int));

        /* create a message digest from the file we're backing up */
        try 
        {
            filedigest = tmpcipher.fileDigest(configfile);
        }
        catch (fileOpenError)
        {
            filedigest = new char[1];
            filedigest[0] = '\0';
        }
        
        /* combine the filestamp, message digest and file (change) information */
        fileinfo = new string(filestamp);
        fileinfo->append(filedigest);
        fileinfo->append(info);
     
        backupDB->insert(module, file, fileinfo->c_str());

        delete ifs;
        delete ofs;
        delete fileinfo;
        delete filestamp;
        delete filedigest;
        delete configfile;
    }
}
