#include <iostream>
#include "exceptions.h"
#include "manager.h"

#define DESCRIPTOR_BUFFER 8192

using namespace regexx;

void manager::readDescriptor(string* descriptorPath)
{
    Regexx * rexx = new Regexx;

    //The regular expressions
    const char * key = "^[[:space:]]*key[[:space:]]*\"([a-zA-Z0-9\\.\\,\\-\\_]+)";
    const char * regvalue = "^[[:space:]]*([0-9])[[:space:]]*(.*)[[:space:]]*$";
    const char * checkvalue = "^([\\.\\/\\,\\-\\+\\=\\_a-zA-Z0-9]*)";
    const char * closeBrace = "^[[:space:]]*\\}";
    const char * openBrace = "^[[:space:]]*\\{";

    char buffer[DESCRIPTOR_BUFFER];
    string * descriptorFile;
    descriptorFile = new string(*descriptorPath);
    descriptorFile->append("olympus.data");
    ifstream * ifs;
    string * key1 = new string();
    
    //Make sure the file opens.
    if (*(ifs = new ifstream(descriptorFile->c_str(), ios::in)))
    {
        //Check for end of file.
        while (!(ifs->eof()))
        {
            //Get the next line from the buffer.
            ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');

            //Check for a first key. if key is found then go through other checks.
            if ((rexx->exec(buffer,key)))
            {
                
                key1->append(rexx->match[0].atom[0].str().c_str());
                rexx->str("");

                //Look for an open brace
                while (!(ifs->eof()) && !(rexx->exec(buffer,openBrace)))
                {
                    ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                }
                
                if (rexx->exec(buffer,openBrace))
                {
                    rexx->str("");
                    
                    // Loop here until close brace to find all the second
                    // keys belonging to the current first key.
                    while (!(ifs->eof()) && !(rexx->exec(buffer,key)))
                    {
                        ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                    }
                    
                    rexx->str("");

                    while (!(ifs->eof()) && !(rexx->exec(buffer,closeBrace)))
                    {
                        string * key2(NULL);
                        string * value(NULL);
                        rexx->str("");
 
                        while (!(ifs->eof()) && !(rexx->exec(buffer, closeBrace) || (rexx->exec(buffer,key))))
                        {
                            ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                        }
                        
                        if ((rexx->exec(buffer,key)))
                        {
                            key2 = new string(rexx->match[0].atom[0].str().c_str());
                            rexx->str("");

                            //Look for an open brace
                            while (!(ifs->eof()) && !(rexx->exec(buffer,openBrace)))
                            {
                                ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n'); 
                            }
                        
                            if ((rexx->exec(buffer,openBrace)))
                            {
                                ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n'); 
                                rexx->str("");

                                while (!(ifs->eof()) && !(rexx->exec(buffer,closeBrace)))
                                {
                                    rexx->str("");
                                    if ((rexx->exec(buffer,regvalue)))
                                    {
                                        string tmp("");
                                        tmp.append(rexx->match[0].atom[1].str().c_str());
                                        
                                        if ((rexx->match[0].atom[0].str().c_str()[0]) == '1')
                                        {
                                            rexx->str("");
                                            if (rexx->exec(tmp.c_str(),checkvalue))
                                            {
                                                struct stat isFile;
                                            
                                                if ((stat(rexx->match[0].atom[0].str().c_str(), &isFile)) != -1)
                                                {
                                                    value = new string(tmp.c_str());
                                                    rexx->str("");
                                                    while (!(ifs->eof()) && !(rexx->exec(buffer,closeBrace)))
                                                    {
                                                        rexx->str("");
                                                        ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                                                    }        
                                                    
                                                    break;
                                                }
                                            }
                                        }
                                        else if ((rexx->match[0].atom[0].str().c_str()[0]) == '0')
                                        {
                                            value = new string(rexx->match[0].atom[1].str().c_str());
                                            
                                            rexx->str("");
                                            while (!(ifs->eof()) && !(rexx->exec(buffer,closeBrace)))
                                            {
                                                rexx->str("");
                                                ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                                            }
                                            
                                            break;
                                        }
                                    }
                                    rexx->str("");
                                    ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                                }
                                
                                //This is where the code will add to the database.
                                if (!(key1 == NULL) && !(key2 == NULL) && !(value == NULL))
                                {
                                    addValue(key1->c_str(), key2->c_str(), value->c_str());
                                }
                            }
                        } // ((rexx->exec(buffer,key)))
                        delete key2;
                        delete value;
                        
                        //Go to next line since we know the is a closeBrace on this one.
                        ifs->getline(buffer, DESCRIPTOR_BUFFER, '\n');
                    } //  while (!(ifs->eof()) && !(rexx->exec(buffer,closeBrace)))                 
                } //  if (rexx->exec(buffer,openBrace))
                key1->replace(0, key1->length(), "");
                rexx->str("");
            }
        }
    }
    else
    {
        throw fileOpenError(descriptorFile->c_str());
    }

    //Delete these useless things.
    delete key1;
    delete rexx;
    delete descriptorFile;
    delete ifs;
}
