/*
 * sysbackup.h: file backup manager for Olympus
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __sysbackup_h_
#define __sysbackup_h_

#include <iostream>
#include <string>

#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fstream>

#include "config.h"
#include "database.h"
#include "olympus.h"

class sysBackup
{
    public:
        sysBackup(string * dataPath);
        ~sysBackup(void);

        void backup(manager* manager, const char* module, const char* filename, const char* info);
    private:
        int uniqueRevision(const char* file, time_t now);
        char* backupName(const char* file, time_t now, int revision);

	string* dataPath;
        string* backupPath;
        Database* backupDB;
};

#endif /* __sysbackup_h_ */
