/*****************************************************************
 *
 * Copyright (c) 1999-2000 MountLinux Inc.
 *
 * nmPackageManager.h
 *
 * Header for packageManager object.
 *****************************************************************/

#ifndef __packagemanager_h_
#define __packagemanager_h_

// standard headers
#include <time.h>

#include "database.h"

class packageManager
{
 public:
    packageManager(string* dataPath);
    ~packageManager();

    // add one of the different types of data
    void addSoftware(string* pkgname); // new package    
    void addConfig(string* pkgname, string* configflags);
    void addFilename(string* pkgname, string* filename);
    void addInstall(string* pkgname, string* file);

    // retrieval methods
    vector<char*>* getSoftware(void);
    char* getConfigure(const char* pkgname);
    char* getFilename(const char* pkgname);
    vector<char*>* getInstall(const char* pkgname);

 private:
    Database* softwareDB;
    string *dbPath;
};

#endif __packagemanager_h_
