#ifndef __manager_h_
#define __manager_h_

#include <string>
#include <iostream>
#include <fstream>

#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>

#include "database.h"
#include "sysbackup.h"
#include "olympus.h"
#include "regexx.hh"

class manager
{
    public:
        manager(string* dataPath);
        ~manager(void);

        void addValue(const char* key1, const char* key2, const char* value);

        char* filename(const char* module, const char* file);

        void readDescriptor(string* descriptorPath);

        ifstream* fetchConfig(const char* module, const char* file);

        int execute(const char* module, const char* action);

        bool hasEntries(void);

    private:
        Database* systemDB;
        sysBackup* backup;
        string* dataPath;
};		

#endif /* __manager_h_ */
