/*
 * main.cc
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include <stdio.h>
#include <unistd.h>

#include "config.h"
#include "defs.h"
#include "version.h"
#include "random.h"
#include "sequence.h"
#include "olympus.h"
#include "logstream.h"
#include "primepool.h"

/* file paths that may be changed at or during runtime */
string *baseOlympusPath;
string *dataPath;
string *configPath;
string *descriptorPath;
string *tmpDataPath;

/* system databases */
manager *sysManager;
userManager *sysUsers;
packageManager *sysPackages;
sysBackup *backupManager;
sequence serverSequence;

/* random number generator */
CSPRNG *RNG;

/* prime set */
primePool *primeSet;

bool restartPending;
bool shutdownPending;

/****************************************************************************/

logStream errorLog("olympusd", LOG_WARNING);

static void usage(const char* bin)
{
    cerr << "Usage: " << bin << " [options]" << endl;
    cerr << "Options:" << endl;
    cerr << "  -v        display version number" << endl;
}

static void detach(void)
{
    pid_t pid;

    chdir("/");

    if ((pid = fork()) > 0)
    {
        exit(0);
    }
    else if (pid < 0)
    {
        errorLog << "unable to fork new process" << endl;
        exit(1);
    }

    if (freopen("/dev/null", "r", stdin) == NULL)
    {
    }

    if (freopen("/dev/null", "w", stdout) == NULL)
    {
    }

    if (freopen("/dev/null", "w", stderr) == NULL)
    {
    }
}

int main(int argc, char* argv[])
{
    extern char* optarg;
    olympus olympusd;
    bool debug(false);
    int c;

    RNG = new CSPRNG();
    primeSet = new primePool();

    while ((c = getopt(argc, argv, "vD?h")) != EOF)
    {
        switch (c)
        {
            case 'D':
                debug = true;
                break;
            case 'h': case '?':
                usage(argv[0]);
                exit(0);
            case 'v':
                cerr << "olympusd version " << VERSION_OLYMPUS << endl;
                exit(0);
            default:
                usage(argv[0]);
                exit(1);
        }
    }

    if (debug == false)
    {
        detach();
    }

    olympusd.serverMain();

    return 0;
}

