/*
 * logstream.cc:
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#include <stdio.h>

#include <string>
#include "exceptions.h"
#include "logstream.h"

logStream::logStream(const char* ident, int priority)
{
    length = 0;
    level = priority;

    openlog(ident, 0, LOG_DAEMON);
}

void logStream::concatenate(const char* str)
{
    char* ptr(&buffer[length]);

    while (*str)
    {
        if (length == LOG_BUFFER_SIZE)
        {
            log();
            ptr = buffer;
        }
        length++;
        *(ptr++) = *(str++);
    }
}

void logStream::log(void)
{
    buffer[length] = '\0';
    length = 0;

    syslog(level, buffer);
}

logStream& logStream::operator<<(const char* str)
{
    concatenate(str);
    return *this;
}

logStream& logStream::operator<<(string* str)
{
    concatenate(str->c_str());
    return *this;
}

logStream& logStream::operator<<(int d)
{
    string tmpbuffer;
    int c;

    do
    {
        c = d % 10 + 0x30;
        tmpbuffer.insert(0, (char *) &c);
    } while (d = d / 10);

    concatenate(tmpbuffer.c_str());
    return *this;
}

logStream& logStream::operator<<(ostream&(*f)(ostream&))
{
    if (f == endl)
    {
        log();
    }
    return *this;
}
