/*
 * serverconfig.h: configuration file handling for Olympus
 *
 * Copyright (c) 2000 Mount Linux Inc.
 * Licensed under the terms of the GPL
 */

#ifndef __olympusconfig_h_
#define __olympusconfig_h_

#include <iostream>
#include <fstream>
#include <string>

class configNoValue {};

class olympusConfig
{
    public:
        olympusConfig(void);
        ~olympusConfig(void);

        char *getCharValue(char *command);
        int getIntValue(char *command);
        string *getStringValue(char *command);
    private:
        class olympusConfigContext
        {
            public:
                olympusConfigContext(char *command, char *value, olympusConfigContext *next);
                ~olympusConfigContext(void);

                char *command;
                char *value;
                olympusConfigContext *next;
        } *configContext;

        ifstream *configFile;

        void openConfig(void);
        void closeConfig(void);
        int readConfig(void);
        inline int strtolower(char *str);
        int insertCommand(char *command, char *value);
};

#endif /* __olympusconfig_h_ */
